new;
cls;

/*Bailey, N., Kapetanios, G. and Pesaran, H. P. (2015). Exponent of Cross-sectional Dependence: Estimation and Inference. 
                                                   Journal of Applied Econometrics, forthcoming.*/
                                                   
#include code_ord_holm.src;

P=265; /* no. of monthly S&P compositions - 265 in total */
a_size=0.1;

sto_p_corr=zeros(P,1);
sto_b_rej=zeros(P,1);
sto_stat_b_rej=zeros(P,1);
sto_n_or=zeros(P,1);
sto_t_or=zeros(P,1);
sto_n=zeros(P,1);
sto_t=zeros(P,1);
sto_a_ex=zeros(P,1);
sto_a_exl=zeros(P,1);
sto_a_exh=zeros(P,1);
sto_a_res=zeros(P,1);
sto_a_resl=zeros(P,1);
sto_a_resh=zeros(P,1);

for i(1,P,1);

/*********** Input Data *******************/
b="I:\\local_QMUL\\Factor Structure\\S&P_Data\\SP";
e=".xls";
f_number=ftos(i,"%lf",1,0);
data=b$+f_number$+e;

/* Choice of starting point: 144 for 60M hist */
x1 = xlsreadm(data,"b144:fy467",1,0);
x2 = xlsreadm(data,"b144:fy467",2,0);
x3 = xlsreadm(data,"b144:ek467",3,0);
rf=xlsreadm("I:\\local_QMUL\\Factor Structure\\S&P_Data\\RF.xls","b144:b467",1,0);
mkt_rf=xlsreadm("I:\\local_QMUL\\Factor Structure\\S&P_Data\\Mkt_RF.xls","b144:b467",1,0);
x_loop=x1~x2~x3;

t_adj=60; /* Choice of history in no. of months 60 */
x_or=x_loop[i:i+t_adj-1,.];
rf_loop=rf[i:i+t_adj-1,1];
mkt=mkt_rf[i:i+t_adj-1,1];
t_or=rows(x_or);
n_or=cols(x_or);

/* Delete stocks without required history */
x_trans=x_or';
e0=(x_trans[.,1] .eq 0);
x_adj=delif(x_trans,e0);
/* Delete stocks without current data */
e1=(x_adj[.,t_adj] .eq 0);
x_adj1=delif(x_adj,e1);
/* Delete stocks without 5 successive periods of data */
for o(1,rows(x_adj1),1);
for j(1,cols(x_adj1)-4,1);
    if x_adj1[o,j]==0 and x_adj1[o,j+1]==0 and x_adj1[o,j+2]==0 and x_adj1[o,j+3]==0 and x_adj1[o,j+4]==0;
     x_adj1[o,1]=-999;
    endif;
endfor;
endfor;
e2=(x_adj1[.,1] .eq -999);
x_adj2=delif(x_adj1,e2);

/*********** Data Preparation *******************/
/* Simple returns */
x_r=x_adj2';
/* Excess returns */
x_ex=x_r-rf_loop;
t=rows(x_ex);
n=cols(x_ex);
/* CAPM residuals - rhs const and mkt */
mkt1=ones(t,1)~mkt;
coef=inv(mkt1'*mkt1)*mkt1'*x_ex;
x_res=x_ex-mkt1*coef; 
    
/* Average pairwise correlation */
avg_p_corr=avgcorr(x_ex);

/* Direct estimate of alpha */
sse=x_res'*x_res/(t-1); 
sd=sqrt(diag(sse*inv(mkt'*mkt))); 
df=t-1;
t_test=zeros(n,1);    
pval=zeros(n,1);
size=zeros(n,1);
for j(1,cols(coef),1);
t_test[j,1]=coef[2,j]/sd[j,1]; 
pval[j,1]=2*cdftc(abs(t_test[j,1]),df); 
  if pval[j,1]>=0.01; 
   size[j,1]=0;
  else;
   size[j,1]=1;
  endif;
endfor;
b_rej=sumc(size);
stat_b_rej=ln(b_rej)/ln(n);

/* Standardise data */
x_exst=standx(x_ex);
x_resst=standx(x_res);

/********** Exponent of cross-sectional dependence ************/
{rej,a_ex,v_f_ex,rej,rej,ggg_ex,s_ex,rej}=atildeall(x_exst,a_size);
{rej,a_res,v_f_res,rej,rej,ggg_res,s_res,rej}=atildeall(x_resst,a_size);

om_ex=1.65*((1/t)*(v_f_ex)+(4/n)*(n^(1-a_ex)*s_ex/(ggg_ex-1)))^(1/2)/(2*ln(n)); /* 90% CI: 1.65, 95% CI: 1.96 */
om_res=1.65*((1/t)*(v_f_res)+(4/n)*(n^(1-a_res)*s_res/(ggg_res-1)))^(1/2)/(2*ln(n)); /* 90% CI: 1.65, 95% CI: 1.96 */

sto_n_or[i,1]=n_or;
sto_t_or[i,1]=t_or;
sto_n[i,1]=n;
sto_t[i,1]=t;
sto_p_corr[i,1]=avg_p_corr;
sto_stat_b_rej[i,1]=stat_b_rej;
sto_a_ex[i,1]=a_ex;
sto_a_exl[i,1]=a_ex-om_ex; 
sto_a_exh[i,1]=a_ex+om_ex; 
sto_a_res[i,1]=a_res;
sto_a_resl[i,1]=a_res-om_res; 
sto_a_resh[i,1]=a_res+om_res; 

endfor;

/* ***************************** Output ******************************* */
"";"";
"n~t";sto_n~sto_t;
"";"";
"Figures 1 (and 5), 2, 3 - Excess returns: Avg pairwise correlation~~direct alpha~a_low~alpha~a_high";
sto_p_corr~sto_stat_b_rej~sto_a_exl~sto_a_ex~sto_a_exh;
"";"";
"Figure 4 (and 6) - CAPM residuals: a_low~alpha~a_high";
sto_a_resl~sto_a_res~sto_a_resh;

/* ******************************************************** Procedures ******************************************************* */
/* Standardise data */
proc standx(x);
local n,t,m_x,std_x,x_stand;
t=rows(x);
n=cols(x);
m_x=meanc(x)';
std_x=stdc(x)';
x_stand=zeros(t,n);
for i(1,n,1);
x_stand[.,i]=(x[.,i]-m_x[1,i])/std_x[1,i];
endfor;
retp(x_stand);
endp;

/* Average pairwise correlation */
proc avgcorr(x);
local corr_m,low_diag,seq_units,pair_corr,avg_p_corr;
corr_m=corrx(x);
low_diag=vech(corr_m);
seq_units=seqa(1,1,rows(low_diag));
pair_corr=rev(sortc(low_diag~seq_units,1));
pair_corr=pair_corr[n+1:rows(pair_corr),1];
avg_p_corr=(2/(n*(n-1)))*sumc(pair_corr);
retp(avg_p_corr);
endp;
 
