function m_hessian = fn_hess_conloglk_N2psi_NKbeta_Nsgm(v_psi, lambda, v_a, v_b, v_c, v_d, v_e, v_f, m_Wm, m_Wp)
N = size(v_a, 1);
v_psim = v_psi(1:N, 1);
v_psip = v_psi((N + 1):end, 1);
m_Psim = diag(v_psim);
m_Psip = diag(v_psip);

m_A = eye(N) - (m_Psim * m_Wm) - (m_Psip * m_Wp);
v_ssr = v_a + (v_psim .* v_psim .* v_b) + (v_psip .* v_psip .* v_c) - (2 * v_psim .* v_d) - (2 * v_psip .* v_e) + (2 * v_psim .* v_psip .* v_f);

invA = inv(m_A);
m_Qm = m_Wm * invA;
m_Qp = m_Wp * invA;

v_numm = (v_psim .* v_b) - v_d + (v_psip .* v_f);
v_nump = (v_psip .* v_c) - v_e + (v_psim .* v_f);

v_ssrsq = v_ssr.^2;

m_secon_partmm = diag(v_b ./ v_ssr - (2 .* v_numm .* v_numm ./ v_ssrsq));
m_secon_partmp = diag(v_f ./ v_ssr - (2 .* v_numm .* v_nump ./ v_ssrsq));
m_secon_partpp = diag(v_c ./ v_ssr - (2 .* v_nump .* v_nump ./ v_ssrsq));

m_Hmm = m_Qm .* m_Qm' + m_secon_partmm;
m_Hmp = m_Qm .* m_Qp' + m_secon_partmp;
m_Hpp = m_Qp .* m_Qp' + m_secon_partpp;

m_hessian = zeros(2 * N);
m_hessian(1:N, 1:N) = m_Hmm;
m_hessian(1:N, (N + 1):end) = m_Hmp;
m_hessian((N + 1):end, 1:N) = m_Hmp';
m_hessian((N + 1):end, (N + 1):end) = m_Hpp;
