 function [R_u_thr,R_u_p,R_u_n] = MT(res_dm,a_size2,nr) % Demeaned residuals (NxT); size of test; number of regressors
    % Sample covariance and correlation matrices
    V_u_samp=(1/size(res_dm,2))*(res_dm*res_dm');
    D_u_hat=diag(diag(V_u_samp),0);
    R_u_samp=sqrt(D_u_hat)\V_u_samp/sqrt(D_u_hat);
    
    % Estimated W - Multiple Testing: Holm on full matrix
    R_adj1=R_u_samp-eye(size(R_u_samp,1));
    R_adj=tril(R_adj1,-1);
    R_ho=reshape(R_adj,(size(R_u_samp,1))^2,1);
    [R_hoth IX]=sort(abs(R_ho),'descend');
    thr_Rho=zeros(size(R_ho,1)-size(R_u_samp,1),1);
    prel1=zeros(size(R_ho,1),1);
    m=(size(R_u_samp,1)*(size(R_u_samp,1)-1))/2;
    for i=1:m
        p_n1=a_size2/(m-i+1);
        theta1=norminv(1-p_n1/2,0,1);
        if R_hoth(i,1)>=theta1/sqrt(size(res_dm,2)-nr);
           thr_Rho(i,1)=1;
        end    
    end
    thr_Rho1=vertcat(thr_Rho,zeros(size(R_u_samp,1),1));
    for i=1:size(R_u_samp,1)^2
       prel1(IX(i,1))=thr_Rho1(i,1);
    end
    f_Rho=reshape(prel1,size(R_u_samp,1),size(R_u_samp,1));
    R_u_thr=f_Rho+f_Rho'+eye(size(R_u_samp,1));
    R_u_m=zeros(size(R_u_samp,1));
    for i=1:size(R_u_samp,1)
     for j=1:size(R_u_samp,1)
       if R_u_thr(i,j)==1
         R_u_m(i,j)=R_u_samp(i,j);
       end
     end
    end
    
    %W+ and W-
    R_u_p=zeros(size(R_u_samp,1));
    R_u_n=zeros(size(R_u_samp,1));
    R_u_mp=zeros(size(R_u_samp,1));
    R_u_mn=zeros(size(R_u_samp,1));
    for o=1:size(R_u_samp,2)
      for j=1:size(R_u_samp,1)
        if R_u_thr(j,o)==1 && sign(R_u_samp(j,o))>0;
         R_u_p(j,o)=1;
         R_u_mp(j,o)=R_u_samp(j,o);
        end  
        if R_u_thr(j,o)==1 && sign(R_u_samp(j,o))<0;
         R_u_n(j,o)=1;
         R_u_mn(j,o)=R_u_samp(j,o);
        end  
     end
    end
    R_u_mn=R_u_mn+eye(size(R_u_mn,1));   