#include <oxstd.h>
#include <oxdraw.h>
#include <ncls_lib.ox>

main()
{
  format("%#13.3f");

  decl eps, n, nb, stime, i, k, j, u, x, r11, r12, r21, r22, data, m, r, bo, bn, y, fx,
       v, mm, kn, cbo, cbn, en, dx, xx, yy, zz, b1, b2, cb1, cb2, b0, mkn, tn, e1, e2, sig, b, t;

  data = loadmat("data_mpyr.txt");
  data[94][0] = 7.053864;
  data[95][0] = 7.089741;
  data[96][0] = 7.154241;
  data[97][0] = 7.192947;
  data = data[:97][];

  y = data[][0]-data[][1]-data[][2];
  x = data[][3];
  fx = log(x);
  v = ones(sizer(y), 1);

//=========== bivariates VAR(1) estimation =========//
  bn = sols(y, v~fx, 0, &cbo);
 
  en = y - (v ~ fx) * bn;
  dx = diff0(x, 1);

  zz = dx[1:] ~ en[1:];
  yy = var(zz,1)[][:1];
  xx = 1~var(zz,1)[][2:];

  b1 = sols(yy[][0], xx, 0, &cb1);
  e1 = yy[][0] - xx*b1;
  b2 = sols(yy[][1], xx, 0, &cb2);
  e2 = yy[][1] - xx*b2;

  sig = sqrt(varc(e1~e2));
//=================================================//  
  
  n = 100;     // number of observation          
  nb = 10000;  // number of iteration
  mkn = 15;    // bandwidth parameter for NCLS

//  r = (b1' | b2');  	 // benchmark parameter settings from estimation
  r = < 0.0, 0.5, 0.3;
        0.0, 0.3, 0.5;>; // different parameter settings

  b = zeros(nb, mkn);
  t = zeros(nb, mkn);
  v = ones(n, 1);

  ranseed(19681103);
  
  for (i = 0; i < nb; ++i)
  {
    eps = sig .* rann(n+1, 2);
    x = zeros(n+1, 1);
    u = zeros(n+1, 1);

    for (j = 0; j < n; ++j)
    {
      x[j+1] = r[0][0] + r[0][1]*x[j] + r[0][2]*u[j] + eps[j][0];
      u[j+1] = r[1][0] + r[1][1]*x[j] + r[1][2]*u[j] + eps[j][1];
    }

	x = cumulate(x);
	x = x[1:];
	u = u[1:];

	y = bn[0] + bn[1] * log(fabs(x)) + u;

    for (kn = 1; kn <= mkn; kn=kn+2)
    {  
	   b[i][kn-1] = ncls(y, v, v.*.NaN, x, log(fabs(x)), kn, 4, &cbn)[1]';
	}   
  }

  print(bn');
  print(r);
  print(sig);
  print(range(1,mkn,1)' ~ meanc(b)' ~ varc(b - bn[1])' ~ sortcindex(sortcindex(varc(b - bn[1])')));
}