bols(const y, const v, const x1, const x2, const fx2, const mm, const aCovb);
bstr (const sStr, const iN);
bartlette (const dZ);
hac (const mE, const iM, const amLambda);
sols (const mY, const mX, const iM, const amCovb);
dols(const mY, const mX, const mI, const iLeadLag, const iM, const amCovb, const avE);
fmodi (const mY, const vE, const mX, const iM, const amOmega, const amLambda, const avG);
fols (const mY, const mV, const mX, const iM, const amCovb);
ivmake (const mX, const inKn);
bboot (const vU, const iBS);
ncls (const mY, const mV, const mX1, const mX2, const mFX2, const inKn, const iM, const amCovb);
adf (const y, const p, const t, const print);
dindex (const iYear1, const iPeriod1, const iYear2, const iPeriod2, const iFreq);
gls (const mY, const mX, const mI, const iLeadLag, const iM, const amCovb, const avE, const iCondi);
var(const mY, const iP);
pp (const y, const p, const t, const print);
//================================================================================//

bols(const y, const v, const x1, const x2, const fx2, const mm, const aCovb)
{
  decl yy, xx, zz, b1, e1, s, Omega, Lambda, G, Delg, b2, w;
  
  yy = y;
  xx = deletec(v ~ x1 ~ fx2);
  zz = deletec(v ~ x1 ~ x2);

  b1 = invert(zz'xx) * (zz'yy);
  e1 = yy - xx * b1;

  yy = fmodi(yy, e1, deletec(x1~x2), mm, &Omega, &Lambda, &G);
  xx = dropr(xx, 0);
  zz = dropr(zz, 0);
  
  Delg = Lambda[0][1:]' - Lambda[1:][1:]' * G;
  Delg = zeros(sizec(v), 1) | (sizer(yy) * Delg);
  
  b2 = invert(zz'xx) * (zz'yy - Delg);

  w = Omega[0][0] - Omega[0][1:] * G;
  aCovb[0] = w * invert(zz'xx);
  
  return b2;
}    

bstr (const sStr, const iN)
{
  decl sS, i;
  sS = sStr;
  for (i = 1; i < iN; ++i) sS ~= sStr;
  return sS;
}	


bartlette (const dZ)
{
  return 1 - dZ;
}


hac (const mE, const iM, const amLambda)
{
  decl n, mOmega, mLambda, i, mOmegaTau;

  n = sizer(mE);
  mOmega = mE'mE / n;
  amLambda[0] = mE'mE / n;

  for(i = 1; i < iM; ++i)
  {
    mOmegaTau = bartlette(i/iM) * (mE[i:][]'mE[:n-i-1][]) / n;
    amLambda[0] = amLambda[0] + mOmegaTau;	
    mOmega = mOmega + mOmegaTau + mOmegaTau';
  }

  return mOmega;
}


sols(const mY, const mX, const iM, const amCovb)
{
  decl mYY, mXX, n, c, vB, vE, dW, mIXX, mLambda;

  mYY = mY;
  mXX = mX;

  n = sizer(mXX);
  c = sizec(mXX);

  if (n <= c) return 0;

  olsc(mYY, mXX, &vB, &mIXX);
  vE = mYY - mXX * vB;
  dW = hac(vE, iM, &mLambda);
//  dW = dW * sizer(mYY) / (n-c);  // adjust finite sample
  amCovb[0] = dW * mIXX;

  return vB;
}


dols(const mY, const mX, const mI, const iLeadLag, const iM, const amCovb, const avE)
{
  decl mYY, mdI, mXX, cX, mYYmXX, vB, mCovb, i, vE, n, c;

  mYY = mY;
  mdI = diff0(mI, 1, .NaN);
  mXX = mX ~ mdI;
  cX = sizec(mX) - 1;
  
  if (iLeadLag > 0)
  {
    for (i = 1; i <= iLeadLag; ++i)
    {
      mXX = mXX ~ lag0(mdI, i, .NaN) ~ lag0(mdI, -i, .NaN);
    }
  }

  mYYmXX = deleter(mYY ~ mXX);
  
  mYY = mYYmXX[][0];
  mXX = mYYmXX[][1:];

  n = sizer(mXX);
  c = sizec(mXX);
  
  if (n <= c) return 0;

  vB = sols(mYY, mXX, iM, &mCovb);
  avE[0] = mYY - mXX * vB;
  if (iLeadLag >  0) avE[0] = constant(.NaN, iLeadLag+1, 1) | avE[0] | constant(.NaN, iLeadLag, 1);
  if (iLeadLag == 0) avE[0] = constant(.NaN, iLeadLag+1, 1) | avE[0];

  amCovb[0] = mCovb[:cX][:cX];

  return vB[:cX];
}


fmodi(const mY, const vE, const mX, const iM, const amOmega, const amLambda, const avG)
{
  decl mYY, mdX, mEdX, mOmega, mLambda, vG;

  mdX = diff0(mX, 1, .NaN);
  mEdX = vE ~ mdX;
  mEdX = deleter(mEdX);
  mEdX = mEdX - (0 ~ meanc(mEdX[][1:]));
  mdX = mEdX[][1:];

  mOmega = hac(mEdX, iM, &mLambda);
  vG = invert(mOmega[1:][1:]) * mOmega[1:][0];

  mYY = dropr(mY, 0);
  mYY = mYY - mdX * vG;
  amOmega[0] = mOmega;
  amLambda[0] = mLambda;
  avG[0] = vG;
  
  return mYY;
}


fols(const mY, const mV, const mX, const iM, const amCovb)
{
  decl mYY, mXX, vB1, vB2, vE1, mdX, mE1dX, mOmega, mLambda, vDelg, dW, vG, mCovb;

  mYY = mY;	   
  mXX = mV ~ mX;

  vB1 = sols(mYY, mXX, 0, &mCovb);
  vE1 = mYY - mXX * vB1;

  mYY = fmodi(mYY, vE1, mX, iM, &mOmega, &mLambda, &vG);
  mXX = dropr(mXX, 0);
  
  vDelg = mLambda[0][1:]' - mLambda[1:][1:]' * vG;
  vDelg = zeros(sizec(mV), 1) | (sizer(mYY) * vDelg);
  
  vB2 = invert(mXX'mXX) * (mXX'mYY - vDelg);
  dW = mOmega[0][0] - mOmega[0][1:] * vG;
//  dW = dW * sizer(mYY) / (sizer(mYY) - sizec(mXX)); 	 // adjust finite sample
  amCovb[0] = dW * invert(mXX'mXX);
  
  return vB2;
}


ivmake(const mX, const inKn)
{
  decl n, c, vSel, mZ, mZZ, i;

  n = sizer(mX);
  c = sizec(mX);
  mZZ = zeros(n, c);
  
  for (i = 0; i < c; ++i)
  {
    vSel = range(0, n-1, inKn);
    mZ = mX[vSel][i];
    mZ = mZ ** ones(inKn, 1);
	mZ = mZ[:n-1][];
	mZZ[][i] = mZ;
  }	

  return mZZ;
}    


ncls(const mY, const mV, const mX1, const mX2, const mFX2, const iKn, const iM, const amCovb)
{
  decl mYY, mX, mFX, mFZ2, mFZ, vB1, vB2, vE1, vE2, mOmega, mLambda, vG, mVV, mXX1, mXX2, mFXX2,
       mFZZ2, dW, mCovb;

  mYY = mY;	   
  mFZ2 = ivmake(mFX2, iKn);
  mFX = deletec(mV ~ mX1) ~ mFX2;
  mFZ = deletec(mV ~ mX1) ~ mFZ2;
  
  vB1 = invert(mFZ'mFX) * (mFZ'mYY);
  vE1 = mYY - mFX * vB1;

  mX = deletec(mX1 ~ mX2);

  mYY = fmodi(mYY, vE1, mX, iM, &mOmega, &mLambda, &vG);
  mVV = dropr(mV, 0);
  mXX1 = dropr(mX1, 0);
  mXX2 = dropr(mX2, 0);
  mFXX2 = dropr(mFX2, 0);
  mFZZ2 = ivmake(mFXX2, iKn);

  mFX = deletec(mVV ~ mXX1) ~ mFXX2;
  mFZ = deletec(mVV ~ mXX1) ~ mFZZ2;
  
  vB2 = invert(mFZ'mFX) * (mFZ'mYY);
  vE2 = mYY - mFX * vB2;
  
  dW = mOmega[0][0] - mOmega[0][1:] * vG;
//  dW = dW * sizer(mYY)/(sizer(mYY)-sizec(mFX)); 	 // adjust finite sample
  amCovb[0] = dW * invert(mFX'mFX);
  
  return vB2;
}    


bboot(const vU, const iBS)
{
  decl z, iIDX, i, iIDX1;
  
  iIDX = ceil( (sizer(vU)-iBS) * ranu(ceil(sizer(vU)/iBS), 1) );
  iIDX1 = iIDX;

  for (i = 1; i < iBS; ++i)
  {
    iIDX1 = iIDX1 + 1;
    iIDX = iIDX ~ iIDX1;
  }

  iIDX = reshape(iIDX, sizer(iIDX)*sizec(iIDX), 1);
  iIDX = iIDX[:sizer(vU)-1][];
 
  return vU[iIDX][];
}

adf (const vY, const iP, const iT, const iPrint)
{
  decl n, vdY, vYY, mdX, vT, dTS, vB, mCovb;

  n = sizer(vY);
  vdY = diff0(vY, 1);
  vdY = vdY[1:][];
  vYY = vY[:n-2][];

  mdX = lag0(vdY, range(1, iP));
  mdX = mdX[iP:][];

  vdY = vdY[iP:][];
  vYY = vYY[iP:][];

  if (iT == 0) vT = ones(sizer(vdY), 1);
  if (iT == 1) vT = 1 ~ range(1, sizer(vdY))';

  if (iP != 0) vB = sols(vdY, vYY~vT~mdX, 0, &mCovb);
  else         vB = sols(vdY, vYY~vT, 0, &mCovb);

  dTS = vB[0] / sqrt(mCovb[0][0]);

  if (iPrint == 1)
  {
	println("===========================================");
	println("ADF Test        = ", dTS);
	println("Lag Length      = ", iP);
	println("===========================================");
  }

  return dTS;
}


pp (const vY, const iM, const iT, const iPrint)
{
  decl n, vdY, vYY, vT, dTS, vB, mCovb, vE, dL, mLambda, dS, dR;

  n = sizer(vY);
  vdY = diff0(vY, 1);
  vdY = vdY[1:][];
  vYY = vY[:n-2][];

  if (iT == 0) vT = ones(sizer(vdY), 1);
  if (iT == 1) vT = 1 ~ range(1, sizer(vdY))';

  vB = sols(vdY, vYY~vT, 0, &mCovb);
  vE = vdY - (vYY~vT) * vB;
  dL = hac(vE, iM, &mLambda);
  dS = vE'vE / (sizer(vE)-sizec(vYY~vT));
  dR = vE'vE / sizer(vE);

  dTS = vB[0] / sqrt(mCovb[0][0]);
  dTS = sqrt(dS/dL) * dTS -
        sizer(vE) * sqrt(mCovb[0][0]/dS) * (dL-dR) / (2*sqrt(dL));

  if (iPrint == 1)
  {
	println("===========================================");
	println("ADF Test        = ", dTS);
	println("Lag Length      = ", iM);
	println("===========================================");
  }

  return dTS;
}


dindex (const iYear1, const iPeriod1, const iYear2, const iPeriod2, const iFreq)
{
  decl vYear, vPeriod;

  if (iFreq == 12)
  {
    vYear = range(iYear1, iYear2)' ** ones(iFreq, 1);
	vYear = vYear[iPeriod1-1:][];
	vYear = vYear[:sizer(vYear)-1-(iFreq - iPeriod2)][];

	vPeriod = ones(iYear2 - (iYear1 - 1), 1) ** range(1, iFreq)';
	vPeriod = vPeriod[iPeriod1-1:][];
	vPeriod = vPeriod[:sizer(vPeriod)-1-(iFreq - iPeriod2)][];
  }

  return vYear ~ vPeriod;
}


gls (const mY, const mX, const mI, const iLeadLag, const iM, const amCovb, const avE, const iCondi)
{

  decl vBg, mCovBg, vEg, mLambda, mOmegaTau, mOmega, mXX, n, i, mIvEg, mII;

  vBg = dols(mY, mX, mI, iLeadLag, 0, &mCovBg, &vEg);
  if (vBg == 0) return;
  avE[0] = vEg;

  if (iCondi == -1) amCovb[0] = mCovBg;

  if (iCondi != -1)
  {
    mIvEg = deleter(vEg ~ mI);
    vEg = mIvEg[][0];
    mII = mIvEg[][1:];
  
    if (iCondi == 0) mOmega = hac(mII.*vEg, iM, &mLambda);
    if (iCondi == 1)
    {
      mOmega = (vEg'vEg / sizer(vEg)) * (mII'mII / sizer(mII));
      for(i = 1; i < iM; ++i)
      {
        mOmegaTau = bartlette(i/iM) * (vEg[i:][]'vEg[:sizer(vEg)-i-1][] / sizer(vEg))
	                                * (mII[i:][]'mII[:sizer(mII)-i-1][] / sizer(mII));
        mOmega = mOmega + mOmegaTau + mOmegaTau';
      }
    }	
	amCovb[0] =  sizer(mI) * invert(mI'mI) * mOmega * invert(mI'mI);
  }	
   
  return vBg;
}


var(const mY, const iP)
{
  decl mYY, i, iC;

  mYY = mY;
  iC = sizec(mY);
  for (i = 1; i <= iP; ++i) mYY = mYY ~ lag0(mY, i);
  return mYY[iP:][];
}	