#include <oxstd.h>
#include <oxdraw.h>
#include <ncls_lib.ox>

main()
{
  format("%#13.4f");
  
  decl kn, ll, mm, fn_form, pmethod, bsize, bo, bd, bf, bn, data, m, q, r, lr, i,
       y, x, fx, covb, v, ppred, cbo, cbd, cbf, cbn, tau, eo, ed, ef, en, ee, ed1;

  fn_form = 2; // 1=r; 2=log(r);

  kn = 15;     // bandwidth for NCLS
  ll = 4;      // leads and lags for DOLS
  mm = 4;      // bandwidth for Newey-West HAC; 0=Eviews formula

  ppred = 8;   // prediction period

  data=loadmat("data_mpyr.txt");
  data[94][0]=7.053864; data[95][0]=7.089741; data[96][0]=7.154241; data[97][0]=7.192947;
  data=data[:97][];
  //data=data[:45][];
  //data=data[46:][];


  m = data[][0]-data[][1];
  q = data[][2];
  r = data[][3];
  println("# of observation = ", sizer(data));
  
  if (fn_form == 1) lr = r;
  if (fn_form == 2) lr = log(r);
  
  y = m-q;
  x = r;
  fx = lr;
  v = ones(sizer(y), 1);

  if (mm == 0) mm = floor(4*(sizer(y)/100)^(2/9)) + 1;    // bandwidth for Newey-West HAC, Eviews formula

// SOLS
  bo = sols(y, v~fx, mm, &cbo);
  print(bo ~ diagonal(sqrt(cbo))');

// DOLS
  bd = dols(y, v~fx, fx, ll, mm, &cbd, &ed);
  print(bd ~ diagonal(sqrt(cbd))');

// FMOLS
  bf = fols(y, v, fx, mm, &cbf);
  print(bf ~ diagonal(sqrt(cbf))');

// NCLS
  bn=ncls(y, v, v.*.NaN, x, fx, kn, mm, &cbn);
  print(bn ~ diagonal(sqrt(cbn))');

  
// Prediction

  if (ppred!=0)
  {
    for(pmethod = 1; pmethod <= 2; ++pmethod) // 1=one-step ahead, 2=two samples
    {
      i = tau = sizer(y) - 1 - ppred;
      eo = ed = ef = en = zeros(sizer(y),1);

	  if (pmethod == 1)
      {
        for(i; i < sizer(y)-1; ++i)
        {
	      bo = sols(y[:i][], v[:i][]~fx[:i][], mm, &cbo);
     	  bd = dols(y[:i][], v[:i][]~fx[:i][], fx[:i][], ll, mm, &cbd, &ed1);
	      bf = fols(y[:i][], v[:i][], fx[:i][], mm,&cbf);
	      bn = ncls(y[:i][], v[:i][], v[:i][].*.NaN, x[:i][], fx[:i][], kn, mm, &cbn);

	      eo[i+1][] = y[i+1][] - (v[i+1][]~fx[i+1][]) * bo;
	      ed[i+1][] = y[i+1][] - (v[i+1][]~fx[i+1][]) * bd;
	      ef[i+1][] = y[i+1][] - (v[i+1][]~fx[i+1][]) * bf;
	      en[i+1][] = y[i+1][] - (v[i+1][]~fx[i+1][]) * bn;
    	}
	  }	
      if (pmethod == 2)
      {
        bo = sols(y[:i][], v[:i][]~fx[:i][], mm, &cbo);
        bd = dols(y[:i][], v[:i][]~fx[:i][], fx[:i][], ll, mm, &cbd, &ed1);
        bf = fols(y[:i][], v[:i][], fx[:i][], mm, &cbf);
        bn = ncls(y[:i][], v[:i][], v[:i][].*.NaN, x[:i][], fx[:i][], kn, mm, &cbn);

        for(i; i < sizer(y)-1; ++i)
	    {
  	      eo[i+1][] = y[i+1][] - (v[i+1][]~fx[i+1][]) * bo;
          ed[i+1][] = y[i+1][] - (v[i+1][]~fx[i+1][]) * bd;
	      ef[i+1][] = y[i+1][] - (v[i+1][]~fx[i+1][]) * bf;
	      en[i+1][] = y[i+1][] - (v[i+1][]~fx[i+1][]) * bn;
     	}
      }
  
    ee = eo ~ ed ~ ef ~ en;
    print("Prediction Method : ", pmethod);
    print(sizer(ee) ~ sizer(ee[:tau][]) ~ sizer(ee[tau+1:][]));
    print(sumc(ee[tau+1:][] .* ee[tau+1:][]));
    }
  }
}