
% Define a variable that contains the path to the main folder;
mainfold = '';

addpath(fullfile(mainfold,'progs','data'));
addpath(fullfile(mainfold,'progs','matlab functions'));
addpath(fullfile(mainfold,'progs','results','factor model estimates'))
addpath(fullfile(mainfold,'progs','results','reduced form'))
addpath(fullfile(mainfold,'progs','results','simulated factors'))
addpath(fullfile(mainfold,'progs','tables and figures'))

cd(fullfile(mainfold,'progs','results','output'))

%bs = 0;
for bs = 0:50

load('Gender Gap Data.mat','DATA')
DATA = bootsamp(DATA,bs);
load(sprintf('FM_%d',bs),'est');
RF = load(sprintf('RF_%d',bs),'est');
RF = RF.est;

factmoms = FactorMoments(est,DATA);

load(sprintf('SIM_%d',bs),'theta_i');
R = size(theta_i,2);
DATA = repmat(kpfield(DATA,{'grp','t','hgc','pwt'}),[1 R]);
[DATA(:).theta] = theta_i{:};
DATA = DATA(:);
clear theta_i 

TBL_FactorSummary = FactorSummary(factmoms);
TBL_AmeByGrd = AmeByGrd(DATA,est,3,factmoms);
TBL_RFAmeByGrd = AmeByGrd(DATA,RF(1),3,factmoms);
TBL_AmeSchLev = AmeSchLev(DATA,est,factmoms);
TBL_AmeArrest = AmeArrest(DATA,est,factmoms);
TBL_EducationGap = EducationGap(DATA,est,factmoms);
TBL_EducationNoArrest = EducationNoArrest(DATA,est);
TBL_ArrestGap = ArrestGap(DATA,est,factmoms);
TBL_ReducedFormGaps = ReducedFormGaps(DATA,RF);
TBL_MeasureCoefficients = MeasureCoefficients(DATA,est,factmoms);
FIG_DynamicSelection = DynamicSelection(DATA,est,factmoms);
TBL_ModelFit = ModelFit(DATA,est,bs);

save(sprintf('OUT_%d.mat',bs),'TBL_FactorSummary','TBL_AmeByGrd','TBL_RFAmeByGrd','TBL_AmeSchLev'...
    ,'TBL_AmeArrest','TBL_EducationGap','TBL_EducationNoArrest','TBL_ArrestGap','TBL_ReducedFormGaps'...
    ,'TBL_MeasureCoefficients','FIG_DynamicSelection','TBL_ModelFit');

end

