function D = SimulateData(D,est,T,varargin)

rng('default')

N = numel(D);

err = rand(N,2,T);

[D(:).T] = deal(1);
D = structureA2V(D);

FixArrest = [];
FixAttempt = [];
while ~isempty(varargin)
    switch varargin{1}
        case 'grp'
            D.grp(:) = varargin{2};   
        case 'theta'
            D.theta = bsxfun(@plus,D.theta,varargin{2});
        case 't'
            D.t(:) = D.t(:) + varargin{2};
        case 'Arrest'
            FixArrest = varargin{2};
        case 'Attempt'
            FixAttempt = varargin{2};            
        otherwise
            error(['Unexpected Covariate: ' varargin{1}])
    end
    varargin(1:2) = [];
end

D = repmat(D,[1 T]);
[D(:,2:end).hgc] = deal(nan(N,1));
[D(:,1).Attempt] = ones(N,1);
[D(:,2:end).Attempt] = deal(nan(N,1));
[D(:).EdProm] = deal(nan(N,1));
[D(:,2:end).t] = deal(nan(N,1));

for t = 1:T
     
    if isempty(FixArrest)
        arrest_v = [arrestX(D(t)) D(t).theta]*est.arrestcoef;
        arrest_pr = exp(arrest_v)./(1+exp(arrest_v));
        D(t).Arrest = +(err(:,1,t)<arrest_pr);
    else
        D(t).Arrest = FixArrest*ones(N,1);
    end

    I = D(t).hgc<16;

    if ~isempty(FixAttempt)
        D(t).Attempt(I) = FixAttempt*ones(nnz(I),1);
    end
       
    prom_x = [promX(D(t)) Igrp(D(t).theta,D(t).grp)];
    prom_v = sum(prom_x(I,:).*est.promcoef(:,D(t).hgc(I))',2);
    prom_pr = exp(prom_v)./(1+exp(prom_v));
    
    D(t).EdProm(I) = +(err(I,2,t)<prom_pr);
    
    if t<T
        D(t+1).t = D(t).t + 1;
        D(t+1).hgc(~I) = D(t).hgc(~I);
        D(t+1).hgc(I) = D(t).hgc(I) + D(t).EdProm(I);
        D(t+1).Attempt(I) = D(t).Attempt(I).*(D(t).EdProm(I)==0) + 1;
        
        D(t+1).Attempt(D(t+1).hgc==16) = nan;
    end
    
end
    
