function OUTPUT = MeasureCoefficients(DATA,est,factmoms)

nf = 3;

factstdALL = sqrt(diag(factmoms.factcovALL));

load('Gender Gap Data.mat','measInfo')

thetaSamp = vertcat(DATA.theta);
pwt = vertcat(DATA.pwt);
N = size(pwt,1);

addtheta = diag(factstdALL);

meassum = cell(numel(measInfo),1);

for j = 1:numel(measInfo)
    
    if isinf(measInfo(j).type)
        nrows = 1;
        nomval = {'Continuous'};
    else
        nrows = measInfo(j).type;
        if nrows==2
            nomval = {'No','Yes'}';
        elseif strcmp(measInfo(j).name,'family_income_group')
            nomval = {'Missing','$<$\$15K','$\ge$\$15k'}';
        elseif strfind(measInfo(j).name,'mom_parent_style')>0
            nomval = {'Uninvolved','Permissive','Authoritarian','Authoritative'}';
        elseif any(strcmp(measInfo(j).name,{'MomDegree','DadDegree'}))
            nomval = {'Missing','HS Dropout','HS Deg.','Some Col.','Col. Deg.'}';
        else
            nomval = repmat({''},nrows,1);
        end
    end
    
    AME = zeros(nrows,nf);
    
    y0 = [ones(N,1) thetaSamp]*est.meascoef{j}; 
    
    if isinf(measInfo(j).type)
        
        y0 = (pwt'*y0)./sum(pwt);       
        for f = 1:nf
            y1 = [ones(N,1) bsxfun(@plus,thetaSamp,addtheta(f,:))]*est.meascoef{j};
            AME(f) = (pwt'*y1)./sum(pwt) - y0;
        end
        
    else
        
        y0 = exp([zeros(N,1) y0]);
        y0 = bsxfun(@rdivide,y0,sum(y0,2));
        y0 = (pwt'*y0)./sum(pwt);
        
        for f = 1:nf
            y1 = [ones(N,1) bsxfun(@plus,thetaSamp,addtheta(f,:))]*est.meascoef{j};
            y1 = exp([zeros(N,1) y1]);
            y1 = bsxfun(@rdivide,y1,sum(y1,2));
            AME(:,f) = (pwt'*y1)./sum(pwt) - y0;
        end
        
    end
    
    AMEzero = (AME==0);
    AME = num2cell(AME);
    AME(AMEzero) = deal({'0'});
        
    baseval = y0';
        
    meassum{j} = [nomval num2cell(baseval) AME];
    
    clear nomval baseval AME
    
end

[~,measorder] = sort({measInfo.name});

meassum2 = cell(numel(measInfo),1);
for j = 1:numel(measInfo)
    getj = measorder(j);
    nrows = size(meassum{getj},1);
    if nrows==2
        nrows = 1;
        X = meassum{getj}(2,:);
    else
        X = meassum{getj};
    end
    rname = cell(nrows,1);
    rname{1} = [num2str(j) '. ' strrep(measInfo(getj).name,'_',' ')];
    meassum2{j} = [rname  X];
end
    
OUTPUT = struct();
OUTPUT.Long = vertcat(meassum2{:});
OUTPUT.Short = vertcat(meassum2{[10 18 31 32 35 53]});



