function OUTPUT = EducationNoArrest(DATA,est)

numGRP = 6;
T = 9;

D = rmfield(DATA,{'hgc','t'});
[D(:).hgc] = deal(9);
[D(:).t] = deal(1);

D0 = SimulateData(D,est,T+1);
ARR = max(horzcat(D0.Arrest),[],2)==1;
D0 = D0(end);

D1 = SimulateData(D,est,T+1,'Arrest',0);
D1 = D1(end);

calcpr = @(D,I) ( D.pwt(I)'*bsxfun(@ge,D.hgc(I),[12 13 16]) )./sum(D.pwt(I));

EdAttain = zeros(3,2,numGRP);
for g = 1:numGRP
    
    I = (D0.grp==g) & (ARR==1);
    EdAttain(:,1,g) = calcpr(D0,I);
    EdAttain(:,2,g) = calcpr(D1,I)-calcpr(D0,I);

end

EdAttain = reshape(EdAttain,[3 2 2 3]); %hgc, effect, gender, race;
EdAttain = permute(EdAttain,[1 2 4 3]); %hgc, effect, race, gender 
EdAttain = reshape(EdAttain(:,:,[2 1 3],:),[3 6 2]); % re-order race: black, white, hispanic;

rownames = {'HS Grad. and Higher','College Enroll and Higher','College Grad. and Higher'};

OUTPUT = struct();
OUTPUT.EdAttain_Male = [rownames' num2cell(EdAttain(:,:,1))];
OUTPUT.EdAttain_Female = [rownames' num2cell(EdAttain(:,:,2))];
