function OUTPUT = EducationGap(DATA,est,factmoms)

nf = 3;
T = 9;

factmeanGRP = factmoms.factmeanGRP;

D = rmfield(DATA,{'hgc','t'});
[D(:).hgc] = deal(9);
[D(:).t] = deal(1);

calcpr = @(D) ( D(end).pwt'*bsxfun(@ge,D(end).hgc,[12 13 16]) )./sum(D(end).pwt);

prBase = zeros(3,2,3);
EqSkill = zeros(3,nf+1,3);

r = 1;
for g = [1 3 5]
    
    DF = D(vertcat(D.grp)==(g+1)); 
    pr_female = calcpr(SimulateData(DF,est,T+1));
    
    DM = D(vertcat(D.grp)==g); 
    pr_male = calcpr(SimulateData(DM,est,T+1));
    
    prBase(:,:,r) = [pr_female' (pr_male-pr_female)'];

    skilldiff = factmeanGRP(:,g+1)-factmeanGRP(:,g);
    addtheta = [diag(skilldiff); skilldiff'];    
    for f = 1:nf+1
        EqSkill(:,f,r) = calcpr(SimulateData(DM,est,T+1,'theta',addtheta(f,:))) - pr_female;
    end
    r = r + 1;
end

CF1 = cat(2,prBase,EqSkill);

rownames = {'HS Grad. and Higher','College Enroll and Higher','College Grad. and Higher'};
EqSkill_White = [rownames' num2cell(CF1(:,:,1))];
EqSkill_Black = [rownames' num2cell(CF1(:,:,2))];
EqSkill_Hisp = [rownames' num2cell(CF1(:,:,3))];
    
calcpr = @(D) ( D(end).pwt'*(D(end).hgc>=13) )./sum(D(end).pwt);

WFSkill = zeros(nf+1,6);
WFbaselinegap = zeros(1,6);
for c = 1:6
    switch c
        case 1
            gleft = 3; gright = 4;
        case 2
            gleft = 5; gright = 6;
        case 3
            gleft = 3; gright = 1;
        case 4
            gleft = 5; gright = 1;
        case 5
            gleft = 4; gright = 2;
        case 6
            gleft = 6; gright = 2;
    end
    
    Dr = D(vertcat(D.grp)==gright);
    Dl = D(vertcat(D.grp)==gleft);

    WFbaselinegap(c) = calcpr(SimulateData(Dl,est,T+1)) - calcpr(SimulateData(Dr,est,T+1));
   
    skilldiff = factmeanGRP(:,2)-factmeanGRP(:,gleft);
    addthetal = [diag(skilldiff); skilldiff'];
    
    skilldiff = factmeanGRP(:,2)-factmeanGRP(:,gright);
    addthetar = [diag(skilldiff); skilldiff'];

    for f = 1:nf+1
        WFSkill(f,c) = calcpr(SimulateData(Dl,est,T+1,'theta',addthetal(f,:))) - ...
            calcpr(SimulateData(Dr,est,T+1,'theta',addthetar(f,:)));
    end
    
end

skillnames = {'Family','Math/Verbal','Behavior'};
WFbasegap_Black = [{'Baseline Gap'} num2cell(WFbaselinegap(:,[1 3 5]))];
WFSkillgap_Black = [[strcat(skillnames,' Only') {'All Factors'}]' num2cell(WFSkill(:,[1 3 5]))];

WFbasegap_Hisp = [{'Baseline Gap'} num2cell(WFbaselinegap(:,[2 4 6]))];
WFSkillgap_Hisp = [[strcat(skillnames,' Only') {'All Factors'}]' num2cell(WFSkill(:,[2 4 6]))];

OUTPUT = struct();
OUTPUT.EqSkill_White = EqSkill_White;
OUTPUT.EqSkill_Black = EqSkill_Black;
OUTPUT.EqSkill_Hisp = EqSkill_Hisp;
OUTPUT.WFbasegap_Black = WFbasegap_Black;
OUTPUT.WFSkillgap_Black = WFSkillgap_Black;
OUTPUT.WFbasegap_Hisp = WFbasegap_Hisp;
OUTPUT.WFSkillgap_Hisp = WFSkillgap_Hisp;
    

