function OUTPUT = AmeByGrd(DATA,est,attempts,factmoms)

factcovALL = factmoms.factcovALL;
factstdALL = sqrt(diag(factcovALL));

nf = numel(factstdALL);

prALL = zeros(1,15);

AmeSkill = nan(nf,15);
AmeCosts = nan(3,15);

addtheta = diag(factstdALL);

for h = 9:15

    calcpr = @(D) D(end).pwt'*(D(end).hgc>h)./sum(D(end).pwt);

    th = cellfun(@(t,hgc) min(t(hgc==h)),{DATA.t},{DATA.hgc},'unif',0);
    hasH = ~cellfun('isempty',th);
    Dh = DATA(hasH);
    [Dh(:).t] = th{hasH};
    [Dh(:).hgc] = deal(h);
    
    prALL(h) = calcpr(SimulateData(Dh,est,attempts+1));

    pr0 = calcpr(SimulateData(Dh,est,attempts+1,'Arrest',0));
        
    AmeCosts(1,h) = calcpr(SimulateData(Dh,est,attempts+1,'Arrest',0,'t',1)) - pr0;
    
    AmeCosts(2,h) = calcpr(SimulateData(Dh,est,attempts+1,'Arrest',0,'Attempt',2)) - ...
         calcpr(SimulateData(Dh,est,attempts+1,'Arrest',0,'Attempt',1));
    
    AmeCosts(3,h) = calcpr(SimulateData(Dh,est,attempts+1,'Arrest',1)) - pr0;
    
    for f = 1:nf
        AmeSkill(f,h) = calcpr(SimulateData(Dh,est,attempts+1,'theta',addtheta(f,:),'Arrest',0)) - pr0;
    end
    
end

Base_pr = [{'Base Cond. Prob.'} num2cell(prALL(9:end))];

AME_Costs = [{'Time','Disruption','Arrest'}' num2cell(AmeCosts(:,9:end))];

skillnames = {'Family','Math/Verbal','Behavior'};

AME_SkillAll = [skillnames' num2cell(AmeSkill(:,9:end))];

OUTPUT = struct();
OUTPUT.Base_pr = Base_pr;
OUTPUT.AME_Costs = AME_Costs;
OUTPUT.AME_SkillAll = AME_SkillAll;



