function OUTPUT = AmeArrests(DATA,est,factmoms)

nf = 3;

factstdALL = sqrt(diag(factmoms.factcovALL));
addtheta = diag(factstdALL);

T = cellfun(@(t) numel(t),{DATA.t},'unif',0);
[DATA(:).T] = T{:};
D = structureA2V(DATA);

X = arrestX(D);
theta_i = repelem(D.theta,D.T,1);
pwt = repelem(D.pwt,D.T,1);

calcpr = @(pr) pwt'*pr./sum(pwt);

arrest_v = [X theta_i]*est.arrestcoef;
arrest_pr = exp(arrest_v)./(1+exp(arrest_v));
pr0 = calcpr(arrest_pr);

AmeSkill = nan(nf,1);
for f = 1:nf
    arrest_v = [X bsxfun(@plus,theta_i,addtheta(f,:))]*est.arrestcoef;
    arrest_pr = exp(arrest_v)./(1+exp(arrest_v));
    AmeSkill(f,1) = calcpr(arrest_pr) - pr0;
end
    
skillnames = {'Family','Math/Verbal','Behavior'};

OUTPUT = struct();
OUTPUT.AmeSkill = [skillnames' num2cell(AmeSkill)];
OUTPUT.Base_pr = [{'Base Probability'} num2cell(pr0)];
