function [est,output] = em_alg(EMstep,sv,p2p,varargin)

EMopt = struct(...
    'maxIter',1e6,...
    'TolX',1e-6,...
    'TolRelX',0,...
    'TolFun',0,...
    'TolRelFun',0,...
    'printIter',1,...
    'savelocation',[]);

while ~isempty(varargin)
    switch varargin{1}
        case fieldnames(EMopt)'
            EMopt.(varargin{1}) = varargin{2};
        otherwise
            error(['Unexpected option: ' varargin{1}])
    end
    varargin(1:2) = [];
end

abch = @(x) x(:,1)-x(:,2);
rech = @(x) (x(:,1)-x(:,2))./(x(:,2)+(1e-6));
pach = @(x) (abs(x(:,2))<.01).*abch(x) + (abs(x(:,2))>=.01).*rech(x);

epnorm = @(x) x./(x'*x);
epval = @(x,y,z) y + epnorm(epnorm(z-y) + epnorm(x-y));

est = sv;
oll = -inf;
op = p2p(est)*ones(1,3);
ep = op(:,1:2);

tic
for m = 1:EMopt.maxIter
    
    [est,ll] = EMstep(est);
    
    op = [p2p(est) op(:,1:end-1)];
    ep = [epval(op(:,1),op(:,2),op(:,3)) ep(:,1:end-1)];
    
    output = struct('Iterations',m,...
                    'LogLike',ll,...
                    'ChangeInLogLike',ll-oll,...
                    'ChangeInParms',norm(abch(op),inf),...
                    'PercentChangeInParms',norm(pach(op),inf),...
                    'ChangeInVecEps',norm(abch(ep),inf),...
                    'Minutes',toc/60);
                
    HasConverged = any([(norm(abch(op),inf)<EMopt.TolX) 
            (norm(pach(op),inf)<EMopt.TolRelX) 
            (norm(ll-oll,inf)<EMopt.TolFun)
            (norm((ll-oll)/oll,inf)<EMopt.TolRelFun)]);
                    
    if (m==1) || (rem(m,EMopt.printIter)==0) || HasConverged
        fprintf('%d \t',m);
        fprintf('%8.6f \t',ll);
        fprintf('%8.6f \t',(ll-oll));
        fprintf('%8.10f \t',(ll-oll)/abs(oll));
        fprintf('%8.6f \t',norm(abch(op),inf));
        fprintf('%d \t',sum(abs(abch(op))>=EMopt.TolX));
        fprintf('%8.6f \t',norm(pach(op),inf));
        fprintf('%d \t',sum(abs(pach(op))>=EMopt.TolRelX));
        fprintf('%8.6f \t',norm(abch(ep),inf));
        fprintf('%8.0f \n',toc);
    end
   
    if ~isempty(EMopt.savelocation)
        save(EMopt.savelocation,'est','output','op')
    end
        
    if HasConverged, break; end
    
    if (norm(abch(ep),inf)<EMopt.TolX)       
        est = p2p(ep(:,1));
    end
  
    oll = ll;

end
        
end



