
% Define a variable that contains the path to the main folder;
mainfold = '';

addpath(fullfile(mainfold,'progs','data'));
addpath(fullfile(mainfold,'progs','matlab functions'));
addpath(fullfile(mainfold,'progs','results','factor model estimates'))

load('Gender Gap Data.mat')
load('FM_0','est')

loadings = cellfun(@(x) max(x(2:end,:),[],2),est.meascoef,'unif',0);
loadings = cat(2,loadings{:})'~=0;

meashas = round(100*mean(isnan(vertcat(DATA.meas)),1)',1);

all_meas = all(loadings,2);
fam_meas = loadings(:,1) & ~any(loadings(:,2:3),2);
cog_meas = loadings(:,2) & ~any(loadings(:,[1 3]),2);
beh_meas = loadings(:,3) & ~any(loadings(:,1:2),2);
cogbeh_meas = ~loadings(:,1) & all(loadings(:,2:3),2);

chk_assign = all((all_meas+fam_meas+cog_meas+beh_meas+cogbeh_meas)==1);

for f = {fam_meas,cog_meas,beh_meas,cogbeh_meas,all_meas}
    T = table({measInfo(f{1}).name}',meashas(f{1}));
    sortrows(T)
end





        