
% Define a variable that contains the path to the main folder;
mainfold = '';

cd(fullfile(mainfold,'progs','latex output','tables'))

addpath(fullfile(mainfold,'progs','matlab functions'));
addpath(fullfile(mainfold,'progs','results','output'));

clear RES
for bs = 0:50
    OUT = load(sprintf('OUT_%d.mat',bs),'TBL_ModelFit');
    RES(bs+1) = OUT.TBL_ModelFit;
end

NewNames = {'GPA in Grade 8','Any Suspension in 8th Grade','8th Grade Retention'...
    ,'ASVAB Math Knowledge 8th Grade','Log-Family Income conditional on $>$15K'}';
[RES(1).meas_fit(:,1) NewNames]
MeasFit = cellfun(@(x) [NewNames x(:,2:end)],{RES.meas_fit},'unif',0);
latextbl(MeasFit,'Measure_fit.tex','%0.3f',false,false);
latextbl({RES.hgcgrp_fit},'EdGrp_fit.tex','%0.3f',false,false);
latextbl({RES.hgcfreq_fit},'EdFreq_fit.tex','%0.3f',false,false);
latextbl({RES.arrgrp_fit},'ArrGrp_fit.tex','%0.3f',false,false);
