
% Define a variable that contains the path to the main folder;
mainfold = '';

cd(fullfile(mainfold,'progs','latex output','tables'))

addpath(fullfile(mainfold,'stata'));
addpath(fullfile(mainfold,'progs','data'));
addpath(fullfile(mainfold,'progs','matlab functions'));

rord = {'_cons','black','hispanic','black_male','white_male','hispanic_male'};

tab_reg = cell(6,6);
tab_n = cell(1,6);

for t2 = {'base_reg','control_reg'}
for t1 = {'math_verb','behave','fam'}
    T = readtable(sprintf('%s_%s.csv',t1{1},t2{1}),'Delimiter',',','ReadVariableNames',false);
    T = table2cell(T);
    T = cellfun(@(x) strrep(x,'=',''),T,'unif',0);
    T = cellfun(@(x) strrep(x,'"',''),T,'unif',0);

    T = cellfun(@(x) strrep(x,'***','$^{\ast\ast\ast}$'),T,'unif',0);
    T = cellfun(@(x) strrep(x,'**','$^{\ast\ast}$'),T,'unif',0);
    T = cellfun(@(x) strrep(x,'*','$^{\ast}$'),T,'unif',0);
        
    I = ismember(T(:,1),rord);
    T(I,2) = strcat(T(I,2),{' {\scriptsize'},T(I,3),{'}'});
    T(:,3) = [];
    [~,nuord] = ismember(rord,T(:,1));
    T(ismember(T(:,1),rord),:) = T(nuord,:);
           
    if strcmp(t1{1},'fam')
        i = 1;
    elseif strcmp(t1{1},'math_verb')
        i = 3;
    elseif strcmp(t1{1},'behave')  
        i = 5;
    end
    if strcmp(t2{1},'control_reg')
        i = i+1;
    end
    tab_n(:,i) = T(strcmp(T(:,1),'N'),2);
    tab_reg(:,i) = T(ismember(T(:,1),rord),2);
end
end

tab_reg = [{'Constant','Black','Hispanic','Black$\times$Male','White$\times$Male','Hispanic$\times$Male'}' tab_reg]; 
tab_n = [{'Observations'} tab_n];

%tab_reg = tab_reg(4:end,:);

latextbl({tab_reg},'PrelimReg.tex',[],false,false);
latextbl({tab_n},'PrelimN.tex',[],false,false);

