
% Define a variable that contains the path to the main folder;
mainfold = '';

cd(fullfile(mainfold,'progs','latex output','tables'))

addpath(fullfile(mainfold,'progs','data'));
addpath(fullfile(mainfold,'progs','matlab functions'));

load('Gender Gap Data.mat')
arrest = vertcat(DATA.arrestY);
grp =repelem(vertcat(DATA.grp),vertcat(DATA.T),1);
numGRP = max(grp);
pwt =repelem(vertcat(DATA.pwt),vertcat(DATA.T),1);
arrestrate = zeros(1,numGRP);
for g = 1:numGRP
    I = (grp==g);
    a = arrest(I,2);
    w = pwt(I);
    arrestrate(g) = (w'*a)/sum(w);
end
arrestrate = reshape(arrestrate,[1 2 3]);
arrestrate = arrestrate(1,:,[2 1 3]);
arrestrate = reshape(arrestrate,[1 numGRP]);

clearvars -except arrestrate

load('summary data age 24')
numGRP = max(D.grp);

EverArrest = nan(1,numGRP);
for g = 1:numGRP
    I = (D.grp==g) & (~isnan(D.Arrest24));
    Arr = D.Arrest24(I);
    w = D.wt_R1(I);
    EverArrest(1,g) = (w'*(Arr>0))./sum(w);
end
EverArrest = reshape(EverArrest,[1 2 3]);
EverArrest = EverArrest(:,:,[2 1 3]);
EverArrest = reshape(EverArrest,[1 numGRP]);

TBL = [{'Annual Arrest Rate'} num2cell(100*arrestrate);
    {'\% Ever Arrested Before Age 25'} num2cell(100*EverArrest)];

latextbl({TBL},'SumArrest.tex','%0.1f',false,false);

EdAndArr = nan(3,numGRP,2);
for g = 1:numGRP
    for a = 0:1
        I = (D.grp==g) & (~isnan(D.hgc24)) & (D.Arrest24==a);
        hgc = D.hgc24(I);
        w = D.wt_R1(I);
        EdAndArr(1,g,a+1) = (w'*(hgc<=11))/sum(w);
        EdAndArr(2,g,a+1) = (w'*(hgc==12))/sum(w);
        EdAndArr(3,g,a+1) = (w'*(hgc>=13))/sum(w);
    end
end
EdAndArr = reshape(EdAndArr,[3 2 3 2]);
EdAndArr = EdAndArr(:,:,[2 1 3],:);
EdAndArr = reshape(EdAndArr,[3 numGRP 2]);
      
%ednames = {'High School Dropout','High School Degree Only','College Enrollment'};
%latextbl({[ednames' num2cell(100*EdAndArr(:,:,1))]},'SumEdNeverArrest.tex','%0.1f',false,false);
%latextbl({[ednames' num2cell(100*EdAndArr(:,:,2))]},'SumEdArrested.tex','%0.1f',false,false);

EdAndArr = [[{'Never Arrested'} num2cell(100*EdAndArr(3,:,1))];
            [{'Arrested at Least Once'} num2cell(100*EdAndArr(3,:,2))]];
latextbl({EdAndArr},'SumEdArrest.tex','%0.1f',false,false);
        
