
% Define a variable that contains the path to the main folder;
mainfold = '';

cd(fullfile(mainfold,'progs','latex output','figures'))

addpath(fullfile(mainfold,'progs','data'));
addpath(fullfile(mainfold,'progs','matlab functions'));

plotformat = {'interpreter', 'latex','FontUnits','points','FontWeight','normal','FontSize',10,'FontName','Times'};
axisformat = {'FontUnits','points','FontWeight','normal','FontSize',10,'FontName','Times'};

load('summary data age 24')
numGRP = max(D.grp);

EdHist = nan(16,numGRP);
for g = 1:numGRP
    I = (D.grp==g) & (~isnan(D.hgc24));
    hgc = D.hgc24(I);
    w = D.wt_R1(I);    
    for h = 8:16
        EdHist(h,g) = (w'*(hgc>=h))/sum(w);
    end
end

EdRatio = EdHist(:,2:2:end)./EdHist(:,1:2:end);
EdRatio = EdRatio(:,[2 1 3]);
EdLev = (8:16)';

close all
figure('PaperPositionMode', 'manual','PaperUnits','inches', 'PaperSize', [4 3],'PaperPosition', [0 0 4 3]);
hold on
plot(EdLev,EdRatio(EdLev,1),'-k')
plot(EdLev,EdRatio(EdLev,2),'--k')
plot(EdLev,EdRatio(EdLev,3),':k')
set(gca,'YLim',[1 2.2]...
    ,'XLim',[8 16],'XTick',(8:16),'XTickLabel',{'8+','9+','10+','11+','12+','13+','14+','15+','16+'}...
    ,axisformat{:})
xlabel('Highest Grade Completed')
ylabel('Ratio (Female/Male)')
legend({'Black','White','Hispanic'},'Location','southoutside','Orientation','horizontal')

print('-dpdf','SumEd.pdf','-r2000')

