function p2p = vecparm(sv)

[nf,K] = size(sv.factmean);

factorNames = sv.factorNames;
model = sv.model;

factcovFULL = ~isdiag(sv.factcov);

typecoefNORM = sv.typecoef;
typecoefEST = ~(ismember(typecoefNORM,[0 -1 1]) | isnan(typecoefNORM));

split_meascoef = cellfun('size',sv.meascoef,2);
meascoefNORM = cat(2,sv.meascoef{:});
meascoefEST = ~(ismember(meascoefNORM,[0 -1 1]) | isnan(meascoefNORM));

measvarNORM = sv.measvar;
measvarEST = ~(ismember(measvarNORM,[0 -1 1]) | isnan(measvarNORM));

promcoefNORM = sv.promcoef;
promcoefEST = ~(ismember(promcoefNORM,[0 -1 1]) | isnan(promcoefNORM));

arrestcoefNORM = sv.arrestcoef;
arrestcoefEST = ~(ismember(arrestcoefNORM,[0 -1 1]) | isnan(arrestcoefNORM));

split_vec = [ nf*K;
              (nf + factcovFULL*(nf^2-nf)/2);
              nnz(typecoefEST);
              nnz(meascoefEST);
              nnz(measvarEST);
              nnz(promcoefEST);
              nnz(arrestcoefEST)];
                   
p2p = @calc;

function Y = calc(X)
        
    if isstruct(X)==0
        
        X = mat2cell(X,split_vec,1);

        Y.factmean = reshape(X{1},[nf K]);
        
        if factcovFULL
            covchol = zeros(nf);
            covchol(tril(ones(nf))==1) = X{2};
            factcov = covchol*covchol';
            factcov = (factcov + factcov')./2;
        else 
            factcov = diag(exp(X{2}));
        end
        Y.factcov = factcov;
        
        typecoef = typecoefNORM;
        typecoef(typecoefEST) = X{3};
        Y.typecoef = typecoef;
                            
        meascoef = meascoefNORM;
        meascoef(meascoefEST) = X{4};
        Y.meascoef = mat2cell(meascoef,1+nf,split_meascoef);
        
        measvar = measvarNORM;
        measvar(measvarEST) = exp(X{5});
        Y.measvar = measvar;
        
        promcoef = promcoefNORM;
        promcoef(promcoefEST) = X{6};
        Y.promcoef = promcoef;
        
        arrestcoef = arrestcoefNORM;
        arrestcoef(arrestcoefEST) = X{7};
        Y.arrestcoef = arrestcoef;
        
        Y.factorNames = factorNames;
        Y.model = model;
                
    else
        
        if factcovFULL
            covchol = chol(X.factcov,'lower');
            factcovtrans = covchol(tril(ones(nf))==1);
        else
            factcovtrans = log(diag(X.factcov));
        end
                          
        meascoef = cat(2,X.meascoef{:});
                
        Y =[X.factmean(:);
            factcovtrans;
            X.typecoef(typecoefEST);
            meascoef(meascoefEST);
            log(X.measvar(measvarEST))';
            X.promcoef(promcoefEST);
            X.arrestcoef(arrestcoefEST)];

    end
                
end
        
       
end

