function [coef] = updateReg(XX,XY,coef,outcometype)

ndp = ~ismember(coef,[0 1 -1]);

switch outcometype

    case 'discrete'
        
        nc = size(XY,2)+1;
        
        LBXX = kron(-(1/2)*(eye(nc-1) - ones(nc-1)./nc),XX);

        coef(ndp) = coef(ndp) - (LBXX(ndp,ndp) \ XY(ndp));
   
    case 'continuous'
        
        coef(ndp) = XX(ndp,ndp) \ (XY(ndp) - XX(ndp,~ndp)*coef(~ndp));
        
    otherwise
        
        error(['Unknown Outcome Type: ' outcometype])

end
     