
% Define a variable that contains the path to the main folder;
mainfold = '';

addpath(fullfile(mainfold,'progs','data'));
addpath(fullfile(mainfold,'progs','matlab functions'));

cd(fullfile(mainfold,'progs','full model'))

load('Gender Gap Data.mat')

nf = 3;
numGRP = 6;
factorNames = {'Family','Cognitive','Behavior'};

numW = numel(measInfo);
grp = vertcat(DATA.grp);

meas = vertcat(DATA.meas);

measName = {measInfo.name};
measType = vertcat(measInfo.type);
measSimp = regexprep(measName,'_(6|7|8)$','');

%%  Factor Info

measloadMAP = zeros(nf,numel(measName));

usemeas = {'brokenHH'
      'family_incomeLOG'
      'family_income_group'
      'mom_parent_style'
      'num_HH_under18'
      'MomDegree'
      'DadDegree'};
measloadMAP(1,ismember(measSimp,usemeas)) = nan;
measloadMAP(1,strcmp(measName,'family_incomeLOG')) = 1;  

usemeas = {'piat'
        'ASVAB_AR'
        'ASVAB_MK'
        'ASVAB_PC'
        'ASVAB_WK'};
measloadMAP(2,ismember(measSimp,usemeas)) = nan;

usemeas = {'alcohol'
      'attack'
      'marij'
      'sex'
      'smoke'};
measloadMAP(3,ismember(measSimp,usemeas)) = nan;

usemeas = {'GPAin8'
          'retention'
          'days_suspendedANY'
          'days_suspendedLOG'
          'HW_hrs_wkANY'
          'HW_hrs_wkLOG'
          'READ_hrs_wkANY'
          'READ_hrs_wkLOG'};
measloadMAP(2:3,ismember(measSimp,usemeas)) = nan;
measloadMAP(2,strcmp(measName,'GPAin8_8')) = 1; 
measloadMAP(3,strcmp(measName,'days_suspendedLOG_8')) = -1; 

measloadMAP(:,all(measloadMAP==0,1)) = nan;

measTab = array2table([measName' num2cell(measloadMAP') num2cell(measType)]);
measTab.Properties.VariableNames =[{'Name'},factorNames,{'Type'}];
measTab = sortrows(measTab,'Name');
measTab

measNoConst = cellfun(@(x) find(strcmp(measName,x)),{'family_incomeLOG','GPAin8_8','days_suspendedLOG_8'});

%% Starting Values
est.factmean = zeros(nf,1);
est.factcov = eps*ones(nf);
for f = 1:nf
    est.factmean(f) = mean(meas(:,measNoConst(f)),'omitnan')*measloadMAP(f,measNoConst(f));
    est.factcov(f,f) = var(meas(:,measNoConst(f)),'omitnan')./2;
end

est.typecoef = eps*ones(size(typeX(DATA(1)),2),0);

est.meascoef = cell(1,numW);
est.measvar = nan(1,numW);
for j = 1:numW
    W = meas(~isnan(meas(:,j)),j);
    if isinf(measType(j))
        if ismember(j,measNoConst)
            const = 0;
        else
            const = mean(W);
        end
        meascoef = [const;measloadMAP(:,j)];
        est.measvar(j) = var(W);
    else
        const = mean(bsxfun(@eq,W,1:measType(j)));
        const = log(const(2:end)./const(1));
        meascoef = [const;measloadMAP(:,j)*ones(1,measType(j)-1)];
    end
    meascoef(isnan(meascoef)) = eps;
    est.meascoef{j} = meascoef;
end

est.meascoef{measNoConst}

est.promcoef = nan(size(promX(DATA(1)),2)+numel(Igrp(zeros(1,nf),1)),15);
est.promcoef(:,9:15) = eps;
est.promcoef(size(promX(DATA(1)),2)+nf+1:end,9:15) = 0;

est.arrestcoef = eps*ones(size(arrestX(DATA(1)),2)+nf,1);

est.factorNames = factorNames;

est.model = 'full';

save('FM_start.mat','est')

