
% Define a variable that contains the path to the main folder;
mainfold = '';

addpath(fullfile(mainfold,'progs','data'));
addpath(fullfile(mainfold,'progs','matlab functions'));
addpath(fullfile(mainfold,'progs','full model'));

cd(fullfile(mainfold,'progs','results','reduced form'))

load('Gender Gap Data.mat','DATA')

%bs = 0;
for bs = 0:50

D = bootsamp(DATA,bs);

arrestX = vertcat(D.arrestX);
arrestY = vertcat(D.arrestY);
arrestY = arrestY(:,2);
arrestN = vertcat(D.arrestN);
arrestwt = repelem(vertcat(D.pwt),arrestN,1);

promX = vertcat(D.promX);
promY = vertcat(D.promY);
promN = mat2cell(vertcat(D.promN),size(D,1),ones(1,15));
promwt = cellfun(@(n) repelem(vertcat(D.pwt),n,1),promN,'unif',0);

est = struct('promcoef',[nan(27,8) zeros(27,7)],'arrestcoef',zeros(11,1));
xona = (1:8);
est.arrestcoef(xona) = glmfit(arrestX(:,xona),arrestY,'binomial'...
    ,'link','logit','constant','off','weights',arrestwt);
est = repmat(est,[1 3]);

for v = 1:3
    
    if v==1
        xonp = (1:9);
    elseif v==2
        xonp = [1 2 (4:9)];
    elseif v==3
        xonp = [1 (4:9)];
    end        

    for h = 9:15
        X = vertcat(promX{:,h});
        Y = vertcat(promY{:,h});
        Y = Y(:,2);
        wt = promwt{h};
        est(v).promcoef(xonp,h) = glmfit(X(:,xonp),Y,'binomial','link','logit','constant','off','weights',wt);
    end
        
end

save(sprintf('RF_%d.mat',bs),'est')
    
clearvars -except DATA bs

end

    