function theta_OUT = SampleFactors(DATA,est,R,burnin,skip)

N = numel(DATA);

[numFact,numType] = size(est.factmean);
numW = numel(est.meascoef);

type_x = vertcat(DATA.typeX);
expv = exp([zeros(N,1) type_x*est.typecoef]);  
typepr = bsxfun(@rdivide,expv,sum(expv,2));
E = est.factmean;
V = est.factcov;

measHas = vertcat(DATA.measHas);
measY = vertcat(DATA.measY);
grp = vertcat(DATA.grp);
promX = vertcat(DATA.promX);
promY = vertcat(DATA.promY);
promN = cell2mat(cellfun(@(x) size(x,1),promY,'unif',0));
arrestX = vertcat(DATA.arrestX);
arrestY = vertcat(DATA.arrestY);
arrestN = cell2mat(cellfun(@(x) size(x,1),{DATA.arrestY},'unif',0))';

function [theta_i,like] = CANDIDATE
    
    typeI = sum(bsxfun(@lt,cumsum(typepr,2),rand([N 1])),2)+1;
    theta_i = mvnrnd(E(:,typeI)',V);
    
    like = ones(N,1);
    
    meas_x = [ones(N,1) theta_i];
    for j = 1:numW
        I = measHas(:,j);
        if nnz(I)==0
            continue 
        end
        y = cat(1,measY{:,j});
        x = meas_x(I,:);
        if ~isnan(est.measvar(j))
            L = normpdf(y,x*est.meascoef{j},sqrt(est.measvar(j)));
        else
            expv = exp([zeros(nnz(I),1) x*est.meascoef{j}]);            
            pr = bsxfun(@rdivide,expv,sum(expv,2));
            L = prod(pr.^y,2);
        end 
        like(I) = like(I).*L;
    end
    
    if strcmp(est.model,'meas only'), return; end
    
    thetaIgrp = Igrp(theta_i,grp);
    
    for h = find(any(promN>0,1))
        I = promN(:,h)>0;
        n = promN(I,h);
        x = [cat(1,promX{I,h}) repelem(thetaIgrp(I,:),n,1)];
        y = cat(1,promY{I,h});
        expv = exp([zeros(sum(n),1) x*est.promcoef(:,h)]);            
        pr = bsxfun(@rdivide,expv,sum(expv,2));
        L = prod(pr.^y,2);
        L = mat2cell(L,n,1);
        L = cellfun(@(x) prod(x),L,'unif',1);
        like(I) = like(I).*L;
    end
    
    if strcmp(est.model,'meas and prom'), return; end

    I = arrestN>0;
    x = [arrestX repelem(theta_i,arrestN,1)];
    expv = exp([zeros(sum(arrestN),1) x*est.arrestcoef]);    
    pr = bsxfun(@rdivide,expv,sum(expv,2));
    L = prod(pr.^arrestY,2);  
    L = mat2cell(L,arrestN,1);
    L = cellfun(@(x) prod(x),L(I),'unif',1);
    like(I) = like(I).*L;
        
end
    
theta_OUT = zeros(N,numFact,R);
rng('default')
[theta_i,like] = CANDIDATE;
r = 0;
tic
for i = 1:(burnin + skip*R)
    [theta_i_cand,like_cand] = CANDIDATE;
    accept_cand = rand([N 1])<=(like_cand./like);
    theta_i(accept_cand,:) = theta_i_cand(accept_cand,:);
    like(accept_cand) = like_cand(accept_cand);
    if ismember(i,burnin + (1:skip:skip*R))
        r = r + 1;
        theta_OUT(:,:,r) = theta_i;
        fprintf('Number of draws: %d out of %d (%0.0f sec.) \n',r,R,toc);
    end
    if r==R, break, end
end

theta_OUT = mat2cell(theta_OUT,ones(N,1),numFact,ones(R,1));
theta_OUT = reshape(theta_OUT,[N R]);

end
