
proc transpose data=frawdata.yearly_prisec (rename=(R0000100=id)) out=ed_acadyr;
	by id;
run;

data ed_acadyr;
	set ed_acadyr;	
	
	if substr(_label_,1,2) ne "CV" then academic_yr = substr(_label_,1,4)+0;
		else academic_yr = substr(_label_,length(_label_)-3,4) + 0;
	
	if substr(_label_,6,16) = "SCH: PROGRESSION" then lab = "grade_progression   ";
	else if substr(_label_,6,19) = "SCH: GRADE ATTENDED" then lab = "grade_attended";
	else if substr(_label_,6,15) = "SCH: SUSPENSION" then lab = "days_suspended";
	else if substr(_label_,1,6) = "CV_HGC" then lab = "HGCprisec_startacyr";
	else if substr(_label_,1,17) = "CV_HIGHEST_DEGREE" then lab = "HDC_startacyr";

run;
proc sort data=ed_acadyr; by id academic_yr; run;

proc transpose data = ed_acadyr out=ed_acadyr (drop=_name_);
	by id academic_yr;
	id lab;
	var col1;
run;
