
proc transpose data=frawdata.interview (rename=(R0000100=id)) out=int_tmp;
	by id;
run;

data int_tmp;
	set int_tmp;

	roundyr=substr(_label_,length(_label_)-3,4)+0;

	length lab $20.;
	if index(_label_,"CV_INTERVIEW_CMONTH")>0 then lab="interviewCM";
	else if index(_label_,"CV_INTERVIEW_DATE")>0 then do;
		if substr(_name_,length(_name_),1)=0 then lab="day";
		if substr(_name_,length(_name_),1)=1 then lab="mon";
		if substr(_name_,length(_name_),1)=2 then lab="yr";
	end;
	else if index(_label_,"CV_HGC_EVER")>0 then lab="cv_HGC";
	else if index(_label_,"CV_HIGHEST_DEGREE")>0 then lab="cv_HDC";
	else if index(_label_,"CV_ENROLLSTAT")>0 then lab="cv_Enrollstat";
	else if index(_label_,"GRADES RCVD 8TH GRADE")>0 then lab = "GPAin8";
	
	else if index(_label_,"SPEND TIME DOING HOMEWORK")>0 then lab = "HW_does";
	else if index(_label_,"# WKDAYS DO HOMEWORK ")>0 then lab = "HW_wkday_times";
	else if index(_label_,"TIME/WKDAY DOING HOMEWORK (HR) ")>0 then lab = "HW_wkday_hr";
	else if index(_label_,"TIME/WKDAY DOING HOMEWORK (MIN)")>0 then lab = "HW_wkday_min";
	else if index(_label_,"TIME/WKEND DOING HOMEWORK (HR) ")>0 then lab = "HW_wkend_hr";
	else if index(_label_,"TIME/WKEND DOING HOMEWORK (MIN) ")>0 then lab = "HW_wkend_min";
	else if index(_label_,"SPEND TIME READING FOR PLEASURE? ")>0 then lab = "RD_does";
	else if index(_label_,"# WKDAYS R READ FOR PLEASURE")>0 then lab = "RD_wkday_times";
	else if index(_label_,"TIME/WKDAY R READ PLEASURE (HR) ")>0 then lab = "RD_wkday_hr";
	else if index(_label_,"TIME/WKDAY R READ PLEASURE (MIN)")>0 then lab = "RD_wkday_min";
	else if index(_label_,"TIME/WKEND READ PLEASURE (HR) ")>0 then lab = "RD_wkend_hr";
	else if index(_label_,"TIME/WKEND READ PLEASURE (MIN)")>0 then lab = "RD_wkend_min";
	else if index(_label_,"CV_INCOME_GROSS_YR")>0 then lab = "family_income";
	else if index(_label_,"CV_HH_POV_RATIO")>0 then lab = "income_poverty_ratio";
	else if index(_label_,"CV_YTH_REL_HH_CURRENT")>0 then lab = "rel_to_HH";
	else if index(_label_,"CV_HH_UNDER_18")>0 then lab = "num_HH_under18";
	else if index(_label_,"CV_PIAT_STANDARD")>0 then lab = "piat";
	else if index(_label_,"RES MOM'S PARENT STYLE")>0
			or index(_label_,"RES MOMS PARENT STYLE")>0 then lab = "mom_parent_style";
	
run;

proc freq data = int_tmp; tables lab; run;

proc sort data = int_tmp; by id roundyr; run;

proc transpose data=int_tmp out=int_tmp (drop=_name_);
	by id roundyr;
	id lab;
	var col1;
run;

data int_tmp;
	set int_tmp;
	interviewdate=mdy(mon,day,yr);
	format interviewdate mmddyy8.;
	drop mon day yr;
run;

data interview;
	set int_tmp;
run;

proc datasets; delete int_tmp; run;

