
data indiv (drop = R9705300 R9705400 R9705500 R9706000 R9706500 R9706600 R9706700 R9707200)
	asvab (keep = id R9705300 R9705400 R9705500 R9706000 R9706500 R9706600 R9706700 R9707200);
	set frawdata.individual (rename=(R0536401=DOB_month R0536402=DOB_year));
	rename 
		R0000100=id 
		R0536300=gender 
		R0538600=hisp  
		R0538700=race
		R1235800=samptype   
		R1482600=race_eth  
		R1302400=HGC_BIO_DAD
		R1302500=HGC_BIO_MOM
		R1205100=rel_to_HH2
		R1205200=rel_to_HH6
    	R1205000=rel_to_HH12
    	
    	Z9083800=hgc_ever
    	Z9083900=hdc_ever
    	Z9084100=gedCM  
		Z9084200=hsdipCM  
		Z9084300=aaCM  
		Z9084400=baCM  
		Z9084500=ProfCM 
		Z9084600=phdCM   
		Z9084700=maCM   
		Z9084800=hsleftCM;
		
	DOB_CM = (dob_year-1980)*12+dob_month;
	dob = mdy(dob_month,1,dob_year);
	DOB_feasible = intnx('month',dob,0,'end')+0;
	
	AGE_ASVAB = (mdy(R9708601,R9708600,R9708602)-dob_feasible)/365.25;
	if R9708601<5 then ASVAB_year = R9708602-1;
		else ASVAB_year = R9708602;
	
	if month(dob_feasible)=2 and day(dob_feasible)=29 then dob_feasible = dob_feasible-1;
		
	format DOB_feasible mmddyy8.;
	
	drop dob R9708602 R9708601 R9708600;
				
run;

proc contents data = indiv; run;

proc transpose data = asvab out = asvab;
	by id;
run;
data asvab;
	set asvab;
	section = substr(_label_,7,2);
	sgn = substr(_label_,22,3);
run;
proc sort data = asvab; by id section; run;
proc transpose data = asvab out = asvab;
	by id section;
	id sgn;
	var col1;
run;
data asvab;
	set asvab;
	Abil = sum(pos,-neg)/1000;
	lab = compress("ASVAB_" || section);
run;
proc transpose data = asvab out=asvab (drop=_name_);
	by id;
	id lab;
	var abil;
run;

data wt_R1;
	infile '/folders/myshortcuts/GenderGap/supplemental files/nlsy97/raw data/customweight_nlsy97_5345d052c70d7.dat' 
	lrecl=211 missover DSD DLM=' ' print;
	input id wt_R1;
run;

data individual;
	merge indiv asvab wt_r1;
	by id;
	wt_R1 = wt_R1/100;
run;

*** normalize ASVAB by AGE ****;

data scors;
	set individual;
	by id;	
	agegrp = floor((age_asvab*100)/25)*25/100;	
	if 12<=agegrp<=12.5 then agegrp = 12.5;
	if 17.5<=agegrp<=18 then agegrp = 17.5;
run;
proc transpose data = scors out = scors;
	where agegrp ne .;
	by id agegrp wt_R1;
	var asvab_ar asvab_mk asvab_pc asvab_wk;
run;
proc sort data = scors; by agegrp _name_; run;
proc means data = scors vardef = WGT noprint;
	by agegrp _name_;
	weight wt_r1;
	output out = scors_dist (drop = _type_ _freq_) mean(col1)=mean_col1 std(col1)=std_col1;
run;
data scors_norm;
	merge scors scors_dist;
	by agegrp _name_;
	norm_score = round((col1-mean_col1)/std_col1,.001);
	lab = _name_ || "_AGE_NORMED";
run;
proc sort data = scors_norm; by id; run;
proc transpose data = scors_norm out=scors_norm (drop=_name_);
	by id;
	id lab;
	var norm_score;
run;

data individual;
	merge individual scors_norm;
	by id;
run;
	
proc datasets; delete indiv asvab wt_r1 scors scors_dist scors_norm; run;
	

