
data hgc;
	merge inc (in=a) ed_acadyr (keep = id yr hgcprisec_startacyr grade_attended);
	by id yr;
	if a;
run;

data HShgc;
	set hgc;
	by id date;
	if first.id then ct = 1;
		else ct + 1;
	if ~(1<=grade_attended<=12) then grade_attended=.;
	keep id hgcprisec_startacyr date grade_attended cm ct;
run;	
data HShgc (drop = ct);
	set HShgc;
	by id date;
	lag1_att = lag(grade_attended);
	lag2_att = lag2(grade_attended);
	lag3_att = lag3(grade_attended);
	lag4_att = lag4(grade_attended);
	lag5_att = lag5(grade_attended);
	lag6_att = lag6(grade_attended);
	lag7_att = lag7(grade_attended);
	if ct<=1 then lag1_att = .;
	if ct<=2 then lag2_att = .;
	if ct<=3 then lag3_att = .;
	if ct<=4 then lag4_att = .;
	if ct<=5 then lag5_att = .;
	if ct<=6 then lag6_att = .;
	if ct<=7 then lag7_att = .;
run;
proc sort data = HShgc; by id descending date; run;
data HShgc;
	set HShgc;
	by id descending date;
	if first.id then ct = 1;
		else ct + 1;
run;
data HShgc (drop = ct);
	set HShgc;
	by id descending date;
	lead1_att = lag(grade_attended);
	lead2_att = lag2(grade_attended);
	lead3_att = lag3(grade_attended);
	lead4_att = lag4(grade_attended);
	lead5_att = lag5(grade_attended);
	lead6_att = lag6(grade_attended);
	lead7_att = lag7(grade_attended);
	if ct<=1 then lead1_att = .;
	if ct<=2 then lead2_att = .;
	if ct<=3 then lead3_att = .;
	if ct<=4 then lead4_att = .;
	if ct<=5 then lead5_att = .;
	if ct<=6 then lead6_att = .;
	if ct<=7 then lead7_att = .;
	
	retain next_hgcprisec_startacyr;
	if first.id then next_hgcprisec_startacyr = .;
	if 1<=hgcprisec_startacyr<=12 then next_hgcprisec_startacyr = hgcprisec_startacyr;

run;
proc sort data = HShgc; by id date; run;
data HShgc;
	merge HShgc individual (keep=id hgc_ever);
	by id;
		
	minforward = min(grade_attended,lead1_att,lead2_att,lead3_att,lead4_att,lead5_att,lead6_att,lead7_att);
	maxbackward = max(lag1_att,lag2_att,lag3_att,lag4_att,lag5_att,lag6_att,lag7_att);
	maxbackward2 = max(lag2_att,lag3_att,lag4_att,lag5_att,lag6_att,lag7_att);
	maxbackward3 = max(lag3_att,lag4_att,lag5_att,lag6_att,lag7_att);
	maxbackward4 = max(lag4_att,lag5_att,lag6_att,lag7_att);
	
	if 1<=hgcprisec_startacyr<=12 and 1<=hgc_ever<=12 then hgc_hs = hgcprisec_startacyr;
		else if minforward>0 and 1<=hgcprisec_startacyr<12 then hgc_hs = hgcprisec_startacyr;
		else if minforward>maxbackward and maxbackward>0 then hgc_hs = maxbackward;
		else if minforward>maxbackward2 and maxbackward2>0 then hgc_hs = maxbackward2;
		else if minforward>maxbackward3 and maxbackward3>0 then hgc_hs = maxbackward3;
		else if minforward>maxbackward4 and maxbackward4>0 then hgc_hs = maxbackward4;
		else if minforward = . and 1<=lag1_att<=12 and 1<=next_hgcprisec_startacyr<=12 then do;
			if lag1_att=next_hgcprisec_startacyr then hgc_hs = lag1_att;
				else if lag2_att=next_hgcprisec_startacyr then hgc_hs = lag2_att;
		end;

run;

data hgc;
	merge hgc (drop = hgcprisec_startacyr) hshgc (keep = id cm hgc_hs hgc_ever);
	by id cm;
run;

data edatt;
	set hist_edatt;
	by id yr;
	if first.id = 0;
run;
data edatt;
	merge hgc (in=a keep = id yr date grade_attended) edatt;
	by id yr;
	if a;
	if grade_attended>0 then attend = 1;
	drop grade_attended;
	if attend~=. then attend=(attend>.25);
run;
data edatt;
	set edatt;
	by id yr;
	lag_attend = lag(attend);
	if lag_attend ne attend then newspell = 1;
run;
data edatt;
	set edatt;
	by id yr;
	if first.id then spell = 1;
		else spell + newspell;
run;

data edatt2;
	merge edatt interview (keep = id cv_hgc date where=(date~=.));
	by id date;
run;
data edatt2;
	set edatt2;
	by id date;
	retain spell2;
	if first.id then spell2 = .;
	if spell ne . then spell2 =spell;
run;
data edatt2;
	set edatt2 (where=(cv_hgc ne .));
	by id spell2 date;
	if first.spell2;
run;

data edatt3;
	merge edatt (keep = id yr attend spell) edatt2 (keep = id spell2 cv_hgc rename=(spell2=spell));
	by id spell;
	if attend = 0 and cv_hgc>0 then hgc_static = cv_hgc;
	keep id yr hgc_static;
run;

data hgc;
	merge hgc edatt3;
	by id yr;
	if hgc_hs>0 then hgc = hgc_hs;
		else if hgc_static>0 then hgc = hgc_static;
run;
proc freq data = hgc; where age>=16; tables hgc / missing; run;
data hgc;
	set hgc;
	by id yr;
	retain prevyr prevhgc;
	if first.id then do; 
		prevyr = .;
		prevhgc = .;
	end;
	if hgc_hs>0 then do;
		prevyr = yr;
		prevhgc = hgc_hs;
	end;
run;
proc sort data = hgc; by id descending yr; run;
data hgc;
	set hgc;
	by id descending yr;
	retain nextyr nexthgc;
	if first.id then do;
		nextyr = .;
		nexthgc = .;
	end;
	if hgc_static>0 then do;
		nextyr = yr;
		nexthgc = hgc_static;
	end;
run;
proc sort data = hgc; by id yr; run;
data hgc;
	set hgc;
	if hgc=. and (nextyr-prevyr)>0 and (nextyr-prevyr)=(nexthgc-prevhgc) 
		then hgc = prevhgc + (yr-prevyr);
	keep id cm yr mon age date hgc;
run;
proc freq data = hgc; where age>=16; tables hgc / missing; run;	

data hgc;
	merge hgc interview (keep = id cv_hgc date cm where=(date ne .));
	by id date;
run;
data hgc;
	set hgc;
	by id cm date;
	retain prevhgc CMprevhgc;
	if first.id then do;
		prevhgc = .;
		CMprevhgc = .;
	end;
	if (cv_hgc>0 or hgc>0) then do;
		CMprevhgc = CM;
		if cv_hgc>0 then prevhgc = cv_hgc;
			else prevhgc = hgc;
	end;
run;
proc sort data = hgc; by id descending date; run;
data hgc;
	set hgc;
	by id descending date;
	retain nexthgc CMnexthgc;
	if first.id then do;
		nexthgc = .;
		CMnexthgc = .;
	end;
	if (cv_hgc>0 or hgc>0) then do;
		CMnexthgc = CM;
		if cv_hgc>0 then nexthgc = cv_hgc;
			else nexthgc = hgc;
	end;
run;
proc sort data = hgc; by id date; run;

data hgc;
	set hgc (where=(mon=9));
	
	if hgc = . then do;
		if (CMnexthgc-CM)<=7 and nexthgc>0 then hgc = nexthgc;
			else if prevhgc>0 and prevhgc = nexthgc then hgc = prevhgc;
	end;

run;

proc freq data = hgc; where age>=16; tables hgc / missing; run;
proc freq data = hgc; where hgc = . and age>=16; tables prevhgc*nexthgc / missing; run;
proc freq data = hgc noprint;
	where hgc = . and age>=16;
	tables id / out=missinghGC;
run;

data hgc;
	set hgc;
	keep id cm hgc;
run;

proc datasets; delete edatt edatt2 edatt3 edmon hshgc; run;



	






