program gmm_estimate_timeseparate, eclass
version 9.2

  #delim ;
  syntax [if] [in], x(varlist numeric) y(varname numeric) z(varlist numeric)
    i(varname) t(varname) [cluster(varname) center];
  #delim cr

  *warning: this trashes the data
  *preserve first

  if "`cluster'"~="" local cstr="cluster(`cluster')"

  *SETUP

  *variable names
  unab xx : `x'
  unab yy : `y'
  unab zz : `z'
  global MY_xnames "`xx'"
  global MY_yname "`yy'"
  global MY_znames "`zz'"
  global MY_K_x : word count `xx'
  global MY_K_z : word count `zz'

  *the sample, part 1
  marksample touse
  markout `touse' `t' `x' `y' `z' `cluster'
  markout `touse' `i', strok
  keep if `touse'
  qui tsset `i' `t'
  count
  global MY_N=r(N)

  *matrices we need
  tempname estcoeffs W
  global MY_gmmcoeffs `estcoeffs'
  global MY_gmmw `W'

  *organize the data
  sort `t'
  tempname tvals tfreqs
  qui tab `t', matcell(`tfreqs')
  global MY_T = rowsof(`tfreqs')
  mat tbreaks=J($MY_T,2,.)
  mat tbreaks[1,1]=1
  mat tbreaks[1,2]=`tfreqs'[1,1]
  forvalues tt=2(1)$MY_T {
    local ttm=`tt'-1
    mat tbreaks[`tt',1]=tbreaks[`ttm',2]+1
    mat tbreaks[`tt',2]=tbreaks[`ttm',2]+`tfreqs'[`tt',1]
    }
  global MY_tbreaks tbreaks
  qui levelsof `t', local(my_tlist)
  global MY_tlist "`my_tlist'"


  *ESTIMATION

  tempname c1 c2 J1 J2 S1 S2 V1 V2e Stemp

  *initial consistent estimator
  matrix $MY_gmmw=I(${MY_T}*(${MY_K_z}+1))
  gmm_compute_timeseparate, coeffs(`c1') j(`J1') s(`S1') vcv(`V1') `cstr' `center' t(`t')

  *second-step efficient estimator
  mat $MY_gmmw=invsym(`S1')
  gmm_compute_timeseparate, coeffs(`c2') j(`J2') s(`S2') vcv(`V2e') `cstr' `center' efficient t(`t')

  *clean up results

  *to avoid having equation names
  local namestr "$MY_xnames"
  mat colnames `c1' = `namestr'
  mat colnames `c2' = `namestr'
  mat rownames `V1' = `namestr'
  mat rownames `V2e' = `namestr'
  mat colnames `V2e' = `namestr'

  ereturn clear
  ereturn post, esample(`touse')
  ereturn scalar N = $MY_N
  ereturn matrix b_initial = `c1'
  ereturn matrix vcv_initial = `V1'
  ereturn scalar J_initial = `J1'
  ereturn matrix b_efficient = `c2'
  ereturn matrix vcv_efficient = `V2e'
  ereturn scalar J_efficient = `J2'
  ereturn scalar moments = (${MY_K_z}+1)*${MY_T}
  ereturn scalar parameters = $MY_K_x
  ereturn scalar J_df = e(moments)-e(parameters)
  ereturn local cmd "gmm_estimate_timeseparate"

end


