program factorreg_tcond

  version 10.1

  #delim ;
  syntax, datafile(string) sfxlist(string) idvar(name) res(name) 
    res_t(name);
  #delim cr

  di `". use `datafile'"'
  use `datafile'
  keep if wave $tcond
 
  local dfileshort=subinstr("`datafile'","/",".",.)

  local ls `c(linesize)'

  *gen t=datayear-1972
  gen t=wave

  
  tempname tvals f1 f2 td proj
  tab t, matrow(`tvals')
  mat `f1'=J(rowsof(`tvals'),1,1)
  mat `f2'=(`f1',`tvals')
  mat `proj'=I(rowsof(`tvals'))-`f1'*invsym(`f1''*`f1')*`f1''
  mat `td'=`proj'*`tvals'
  mat `td'=`td'[3...,1]'/`td'[1,1]

  xi i.t, prefix(_T)

  local nw : word count `sfxlist'
  mat `res'=J(4*`nw',1,.)
  
  local rescnames ""
  local pos=1

  tsset `idvar' t
  tempfile temp
  save `temp', replace

  foreach cns in 1 2 {
    local thistry=1
    foreach sfx in `sfxlist' {

      di _newline _newline _newline _newline "---------------------------" _newline
      display "$S_TIME  $S_DATE"

      di "sfx: `sfx'"
      if `cns'==1 di "common time preference"
      else di "heterogeneous time preference"

      use `temp', clear
  keep if wave $tcond


      #delim ;
      *xtivreg2 lfood_real`sfx' _T* (lnetfmy_real`sfx'=lh_leisurea),
      *fe cluster(orig_psu) first;
			  xtivreg2 lcn1 _T* (ly0_h=lh_leisurea),
        *fe cluster(orig_psu) first	
		fe cluster(pid) first	

      #delim cr
      mat gg=e(b)
      mat `res'[`pos',1]=gg[1,1]
      local pos=`pos'+1
      local rescnames "`rescnames' xtivreg`sfx'`cns'"

      di _newline _newline _newline
      *di "   ** regressor = lnetfmy_real`sfx', instrument = lh_leisurea"
      di "   ** regressor = ly0_h, instrument = lh_leisurea"

	  
	  if `thistry'==1 local dinitstr ""
      else local dinitstr "dinit(dcopy)"
      #delim ;
      factorreg_estimate_iv,
       *y(lfood_real`sfx') x(lnetfmy_real`sfx') z(lh_leisurea)
        y(lcn1) x(ly0_h) z(lh_leisurea)

	   i(`idvar') t(t) f(`f`cns'') repeat(1) `dinitstr';
      #delim cr
      ereturn list
      set linesize 255
      mat list e(g_allattempts)
      mat list e(rss_allattempts)
      mat list e(d_allattempts)
      set linesize `ls'
      mat dd=e(d_allattempts)
      local iters=rowsof(dd)
      forvalue iter=1(1)`iters' {
        if dd[`iter',1]~=. {
          local lastiter=`iter'
          mat dcopy=dd[`iter',1...]
          }
        }
      #delim ;
      mat2txt, matrix(dcopy) 
        saving(output/apptable_f2/dmats/`dfileshort'.`sfx'.`cns'.txt)
        replace;
      #delim cr
      mat gg=e(g_allattempts)
      mat `res'[`pos',1]=gg[`lastiter',1]
      local pos=`pos'+1
      local rescnames "`rescnames' factor`sfx'`cns'"
      drop _all

      local thistry=`thistry'+1
      display "$S_TIME  $S_DATE"
      di _newline "---------------------------" _newline _newline _newline _newline

      }

    }
  

  *estimates with heterogeneous time preference only

  mat `res_t'=J(`nw',1,.)
  local rescnames_t ""
  local pos_t=1
  global MY_IV_ibreaks breaks

  foreach sfx in `sfxlist' {
    use `temp', clear
  keep if datayear $tcond

    #delim ;
    *factorreg_setup_iv lnetfmy_real`sfx' lfood_real`sfx' lh_leisurea,
	 factorreg_setup_iv ly0_h lcn1 lh_leisurea,

	
      i(`idvar') t(t) f(`f1') rpfx("myR") added(added);
    *factorreg_compute_iv, d(`td') f(`f1') g(g) y(lfood_real`sfx')
     *x(lnetfmy_real`sfx') z(lh_leisurea);
	  factorreg_compute_iv, d(`td') f(`f1') g(g) y(lcn1)
      x(ly0_h) z(lh_leisurea);
	  
	  
	  
    #delim cr
    di g
    mat `res_t'[`pos_t',1]=g
    local pos_t=`pos_t'+1
    local rescnames_t "`rescnames_t' factor_tonly`sfx'"
    drop _all
    }

  mat rownames `res' = `rescnames'
  mat list `res'
  mat rownames `res_t' = `rescnames_t'
  mat list `res_t'

  drop _all

end
