program factorreg_minstep, eclass
version 10.1

  #delim ;
  syntax varlist [if] [in], f(name) i(varname) t(varname numeric)
    [repeat(integer 10) seed(string) nodisplayearly
     init(name) search(passthru)];
  #delim cr

  *rows of init will be used as an initial guess if specified
  *the parameter vector to be entered here is the one returned in e(d_short)

  local maxopts "nopreserve collinear missing noscvars technique(nr 20 bfgs 5)"
  local tolopts "difficult nonrtolerance"

  * F should include the constant

  * this trashes the data. preserve first.

  local seedsave `c(seed)'
  if "`seed'"=="" set seed 12345
  else set seed `seed'

  if "`displayearly'"=="nodisplayearly" local display1=0
  else local display1=1

  tempname coeffs breaks
  global MY_factorregcoeffs `coeffs'
  global MY_ibreaks `breaks'
  global MY_F `f'

  *out-of-date code that should be cleaned up
  global MY_normb ""

  tempname tvals
  qui tab `t', matrow(`tvals')
  local T=rowsof(`tvals')
  assert `T'==rowsof(`f')

  local k=2+colsof(`f')
  local myparmlist ""
  local mycollist ""
  forvalues tt=`k'(1)`T' {
    local m=`tvals'[`tt',1]
    local myparmlist "`myparmlist' /d`m'"
    local mycollist "`mycollist' d`m':_cons"
    }
  local nparams=`T'-`k'+1
  local mydlist ""
  forvalues tt=1(1)`T' {
    local m=`tvals'[`tt',1]
    local mydlist "`mydlist' d`m'"
    }

  unab varlist : `varlist'
  gettoken y x : varlist
  global MY_yname "`y'"
  global MY_xnames "`x'"
  local nx : word count `x'

  tempname added myR
  #delim ;
  factorreg_setup $MY_yname $MY_xnames `if' `in',
    i(`i') t(`t') rpfx("`myR'") f(`f') added(`added');
  #delim cr

  tempname bsave Jsave csave binit bstore Jstore cstore timestore bnorm btest
  scalar `Jsave'=0
  if `repeat'>0 {
    mat `bstore'=J(`repeat',`nparams',.)
    mat `Jstore'=J(`repeat',1,.)
    if `nx'>0 mat `cstore'=J(`repeat',`nx',.)
    mat `timestore'=J(`repeat',1,.)
    }
  if "`init'"~="" {
    if colsof(`init')~=`nparams' {
      di "cannot use supplied matrix init = `init' due to incorrect dimensions"
      local init ""
      }
    else local initmax=rowsof(`init')
    }
  else local initmax=0
  local attempt=1
  local continue=1
  while `attempt'<=`repeat' & `continue'==1 {
    di _newline _newline "attempt `attempt'"
    timer clear 100
    timer on 100
    if "`init'"~="" & `attempt'<=`initmax' {
      di "initializing with row `attempt' of supplied matrix init = `init'"
      mat `binit'=`init'[`attempt',1...]
      }
    else {
      di "initializing with random vector"
      mat `binit'=0.1*`attempt'*matuniform(1,`nparams')+J(1,`nparams',0.1*`attempt')
      }
    mat colnames `binit' = `mycollist'
    #delim ;
    ml model d2 factorreg_max `myparmlist',
      `maxopts' `tolopts' `search' init(`binit') iter(80) nooutput max;
    #delim cr
    timer off 100
    qui timer list
    mat `timestore'[`attempt',1]=r(t100)
    if `display1' {
      ml display
      if `nx'>0 mat list `coeffs'
      di _newline _newline _newline
      }
    mat `bstore'[`attempt',1]=e(b)
    mat `Jstore'[`attempt',1]=e(ll)
    mat `btest'=e(b)
    if `nx'>0 mat `cstore'[`attempt',1]=`coeffs'
    if (e(ll)>`Jsave' & e(ll)~=.) | `attempt'==1 {
      mat `bsave'=e(b)
      scalar `Jsave'=e(ll)
      if `nx'>0 mat `csave'=`coeffs'
      }
    local attempt=`attempt'+1
    *if result is very ugly, keep trying because it is probably not the minimum
    mat `bnorm'=`btest'*`btest''
    if `bnorm'[1,1]<10*colsof(`btest') local continue=0
    }

  *expand coefficients using normalization
  tempname blong allshort b
  #delim ;
  factorreg_expand, f(`f') dshort(`bsave') dlong(`blong') 
    regcoeffs(`coeffs') allshort(`allshort') alllong(`b');
  #delim cr

  mat colnames `b' = `mydlist' $MY_xnames
  mat coleq `b' = :

  ereturn post `b' 
  ereturn scalar N = $MY_N
  ereturn scalar T = $MY_T
  ereturn matrix d_short = `bsave'
  ereturn scalar rss=-`Jsave'
  if `repeat'>0 {
    ereturn matrix d_allattempts = `bstore'
    mat `Jstore'=-`Jstore'
    ereturn matrix rss_allattempts = `Jstore'
    ereturn matrix time_allattempts = `timestore'
    }
  if `nx'>0 {
    ereturn matrix regcoeffs = `coeffs'
    if `repeat'>0 ereturn matrix regcoeffs_allattempts = `cstore'
    }
  ereturn local cmd "factorreg_estimate"

  ereturn display

  set seed `seedsave'
end



