program factorreg_estimate_iv, eclass
version 10.1

  #delim ;
  syntax [if] [in], x(varname numeric) y(varname numeric) z(varname numeric)
    f(name) i(varname) t(varname numeric)
    [repeat(passthru) seed(passthru) tol(real 1e-5)
     orepeat(integer 10) dinit(name) ginit(real -999)];
  #delim cr

  *iterated iv estimation
  *y=dependent variable
  *x=independent variable
  *z=instrument

  *this trashes the data. preserve first.

  *seed, f, i, t get passed to factorreg_minstep
  *initialize with either dinit (format: e(d_short) from factorreg_minstep)
  *or ginit (but not both)
  *orepeat: iterations on outer loop
  *repeat: ignored; here for compatibility

  tempvar ytemp added
  tempname gtemp jtemp dtemp dfulltemp gsave jsave dsave tvals dguess myR ibreaks gchg
  tempname init testmat
  tempfile mysample_base mysample_ivsetup
  global MY_IV_ibreaks ibreaks

  marksample touse
  markout `touse' `t' `x' `y' `z'
  markout `touse' `i', `strok'
  qui keep if `touse'
  keep `i' `t' `x' `y' `z'

  qui tab `t', matrow(`tvals')
  local T=rowsof(`tvals')
  assert `T'==rowsof(`f')
  local nparams=`T'-1-colsof(`f')

  *need to save the sample, but preserve may already be in use
  qui xi i.`t', prefix(_T)
  qui save `mysample_base'
  drop _T*
  factorreg_setup_iv `x' `y' `z', f(`f') i(`i') t(`t') rpfx("`myR'") added(`added')
  qui save `mysample_ivsetup'

  *initial value of g
  assert (`ginit'==-999 | "`dinit'"=="")
  if "`dinit'"~="" {
    mat `dtemp'=`dinit'
    #delim ;
    factorreg_compute_iv, d(`dtemp') f(`f') g(`gtemp')
      y(`y') x(`x') z(`z');
    #delim cr
    }
  else if `ginit'==-999 scalar `gtemp'=0
  else scalar `gtemp'=`ginit'

  if `orepeat'<1 local orepeat=1
  mat `gsave'=J(`orepeat',1,.)
  mat `jsave'=J(`orepeat',1,.)
  mat `dsave'=J(`orepeat',`nparams',.)
  local iter=1
  scalar `gchg'=`tol'+1
  while `iter'<=`orepeat' & `gchg'>`tol' {
    di _newline _newline
    di "beginning iteration `iter': g = "`gtemp'
    *generate dependent variable
    drop _all
    use `mysample_base'
    qui gen `ytemp'=`y'-`gtemp'*`x'
    *initial guess
    local lb=rowsof(`f')
    mat `dguess'=J(`lb',1,.)
    forvalues j=1(1)`lb' {
      mat `dguess'[`j',1]=`j'
      }
    mat `dguess'=(I(`lb')-`f'*invsym(`f''*`f')*`f'')*`dguess'
    local pos=colsof(`f')+2
    mat `dguess'=`dguess'[`pos'...,1]'/`dguess'[1,1]
    local dosearch ""
    if `iter'>1 {
      mat `testmat'=`dtemp'*`dtemp''
      if `testmat'[1,1]>10*`T' {
        mat `dtemp'=`dtemp'*sqrt(`T'/`testmat'[1,1])
        local dosearch "search(off)"
        }
      mat `init'=(`dtemp' \ `dguess')
      }
    else mat `init' = `dguess'
    if "`dinit'"~="" {
      if `iter'>1 mat `init'=(`init' \ `dinit')
      else mat `init'=(`dinit' \ `init')
      }
    *minimization step
    #delim ;
    factorreg_minstep `ytemp',
      f(`f') i(`i') t(`t') repeat(5) `seed' init(`init') `dosearch';
    #delim cr
    mat `dtemp'=e(d_short)
    mat `dfulltemp'=e(b)
    mat `dsave'[`iter',1]=`dtemp'
    scalar `jtemp'=e(rss)
    mat `jsave'[`iter',1]=`jtemp'
    di "ending iteration `iter': rss = "`jtemp' _c
    drop _all
    *iv step
    use `mysample_ivsetup'
    if `iter'>1 scalar `gchg'=`gtemp'
    #delim ;
    factorreg_compute_iv, d(`dtemp') f(`f') g(`gtemp')
      y(`y') x(`x') z(`z');
    #delim cr
    mat `gsave'[`iter',1]=`gtemp'
    di "; g = "`gtemp'
    if `iter'>1 scalar `gchg'=abs(`gtemp'-`gchg')
    local iter=`iter'+1
    }
  
  ereturn clear
  ereturn matrix g_allattempts = `gsave'
  ereturn matrix rss_allattempts = `jsave'
  ereturn matrix d_allattempts = `dsave'
  ereturn matrix dfull_final=`dfulltemp'

end
