set more off
clear all

include dofiles\defs.do

cd "${path}\shiw\data\clean\"

use "estimates_shiw", clear 
bysort pid: egen minwave=min(wave)
 gen spia=minwave==wave
 gen spia2=(spia==1)&(kb1==1|kb2==1)
 bysort pid: egen initcond=max(spia2)
 
 drop spia*
 
 bysort pid: egen wcount=count(wave) if anno>1998
sort pid wave
gen spia = (pid==pid[_n+1] & wave!=(wave[_n+1]-1))
bysort pid: egen scount=sum(spia)
 drop spia
 gen primeage=eta>=30 & eta<58 /*& staciv==1*/  & initcond==1 /*& totinc1>=0 & apqual_l!=15&apqual_l!=16&ybase_l!=0/*&apqual!=15&apqual!=16*/ */
 


 gen spia=1
 bysort pid: egen nw=sum(spia)
 drop spia
 tab nw
 sort pid anno
 bysort pid: gen n=_n if wave==wave[_n-1]+1
 bysort pid: egen min=min(n)
  bysort pid: replace n=min[_n+1]-1 if n[_n+1]==min
  tab nw
  drop nw
  


sort pid anno
 bysort pid: gen n2=_n if wave==wave[_n-1]+1 & n!=.
 bysort pid: egen nw=max(n2)
 tab nw
 *household monetary nondurable consumption
gen lcn1=ln(cn1)
label var lcn1 "log of household monetary nondurable consumption"

*household disposable income
gen y0_h= yl + yt + ym + yc- yca2 -yl2
gen ly0_h = ln(y0_h + 1)
label var lcn1 "log of household disposable income"



 foreach v in cn1 y0_h  {
    quietly {
      gen `v'_need=`v'/ce
      label var `v'_need "`v'/need"
      gen l`v'_need=ln(`v'_need)
      label var l`v'_need "ln(`v'/need)"
      gen `v'_pc=`v'/ncomp
      label var `v'_pc "`v'/famsize"
      gen l`v'_pc=ln(`v'_pc)
      label var l`v'_pc "ln(`v'/famsize)"
      }
    }
 
gen h_leisurea=8760-hoursyear
gen lh_leisurea=ln(h_leisurea)

gen h_leisurea_t=(8760*nperc-hourstot)/nperc
gen lh_leisurea_t=ln(h_leisurea_t)


cd "${path}\shiw\"


keep primeage nw h_leisurea lh_leisurea* *cn1* *y0_h* wave pid anno peso eta scount

keep if primeage==1 /*& nw>=3*/ & n!=. &  y0_h >=0 & scount==0
drop nw
 gen spia=1
 bysort pid: egen nw=sum(spia)
 drop spia
 keep if nw>=3
 tab nw
 gen seqid_omemb=pid
 save data/loaded/data_omemb, replace
 
 gen seqid_hw=pid
 drop seqid_omemb
 replace lh_leisurea=lh_leisurea_t
 save data/loaded/data_hw, replace

tab scount

*---------------------
* CONSTRUCT BOOTSTRAP SAMPLES
*---------------------

set seed 12345
di "`c(seed)'"
foreach type in `typelist' {
use data/loaded/data_`type', clear
forvalues i=1/`nsamples' {
    di `i'
    preserve
   bsample, /*strata() weight(peso) */  cluster(pid) idcluster(newcluster) 
    egen newid=group(newcluster pid) 
	*egen newid=group(pid)
		
		*duplicates drop pid wave, force
		xtset newid wave
bysort newid: egen wcount=count(wave) if anno>1998
sort newid wave
gen spia = (newid==newid[_n+1] & wave!=(wave[_n+1]-1))
cap drop scount
bysort pid: egen scount=sum(spia)
 drop spia
 tab scount
 keep if scount==0
	save data/bsamples/data_`type'_bs`i'.dta, replace
    restore
    }
 }
di "`c(seed)'"


/*
*need to do some extra iterations (head) to match bootstrap sampling in
*previous code
foreach tbase in head `typelist' {
  if "`tbase'"=="head" local type="hw"
  else local type="`tbase'"
  #delim ;
  doit, cmd(`"use seqid_`type' datayear orig_psu lfood_real* lnetfmy_real* lh_leisurea* lts_leisurea* rtcat
    using data/loaded/data_`type'.dta"');
  #delim cr
  forvalues i=1/`nsamples' {
    di `i'
    preserve
    bsample, cluster(orig_psu) idcluster(newcluster)
    egen newid=group(newcluster seqid_`type')
    if "`tbase'"!="head" save data/bsamples/data_`type'_bs`i'.dta, replace
    restore
    }
  drop _all
  }

di "`c(seed)'"
*/


