set more off
cd "${path}/shiw/data"
*--------------------------------------------------------------
* ALLB1 - EMPLOYEES
*--------------------------------------------------------------
*use "raw/allb1_9814", clear
insheet using "raw/allb1_9814.csv", comma clear
replace pubblico ="1" if pubblico=="Si"
replace pubblico ="2" if pubblico=="No"
destring pubblico, replace
gen indeter=contratt
replace indeter=100 if contratt==1
collapse (min) attivp tuttanno partime contratt pubblico pstra integ (max) dimaz (sum) oretot indeter mesilav orestra ylm ylnm /*oredes*/, by (nquest nord anno)
replace indeter=1 if indeter>=100
replace indeter=0 if indeter>1
la var indeter "titolare di contratto a tempo determinato=0, indeterminato=1"

gen kb1=1
la var kb1 "Identificativo reddito da lavoro dipendente"
la val kb1 kb1

drop if  ylm ==.
recode oretot .=0
recode orestra .=0
recode mesilav (13/max = 12)
replace mesilav=12 if  tuttanno==1
/*MESILAV missing when occasional job (TUTTANNO = 3)
It is necessary to establish a rule to impute MESILAV on these cases.
We impute 1 month*/
replace mesilav=1 if tuttanno==3
drop if  mesilav ==.
recode ylnm .=0
la var orestra "ore straordinarie in media settimanali"
rename orestra kb1orestra
rename oretot kb1oretot
rename mesilav  kb1mesilav
la var kb1oretot "ore settimanali lavorate in media compresi straordinari"
la var kb1mesilav "mesi lavorati se meno di 12"


la var attivp "attivitȠsvolta (dipendente)"
lab def attivp 1"Principale" 2"Secondaria", replace
lab val attivp attivp
rename attivp  kb1attivp
la var partime "lavora a tempo pieno o partime "
lab def partime 1"Tempo pieno" 2"Part-time", replace
la val partime partime
rename partime kb1partime

la val contratt contratt
rename contratt kb1contratt
la var kb1contratt "tipo di contratto"
lab def kb1contratt 1"Tempo indeterminato" 2"tempo determinato" 3"lavoro interinale", replace

la var dimaz "dimesioni azienda"
lab def dimaz 1"Meno di 4 addetti" 2"tra 5 e 15 addetti" 3"tra 16 e 19 addetti" 4"tra 20 e 49 addetti" 5"tra 50 e 99 addetti" 6"tra 100 e 499 addetti" 7"oltre 500 addetti" 8"Dipendente pubblico", replace
la val dimaz dimaz
rename dimaz kb1dimaz
la var pstra "aveva possibilitȠstraordinari?"
lab def pstra 1"Si" 2"No", replace
la val pstra pstra
rename pstra kb1pstra

la var ylm "reddito comlessivo netto annuo"
rename ylm kb1ydip
la var integ "ha ricevuto integrazioni di reddito?"
lab def integ 1"Si" 2"No", replace
rename integ kb1integ
la var ylnm "reddito da fringe benefits"
rename ylnm kb1yfb
rename pubblico kb1pubblico
rename indeter kb1indeter

keep nquest nord anno kb1*

duplicates report nquest nord anno, force
*duplicates drop nquest nord anno, force

gen kb1hoursyear =  (kb1oretot)*kb1mesilav*4
la var kb1hoursyear"ore lavorate nell'anno (derivata)"


for varlist kb1ydip kb1yfb: replace X=X/1.93627 if anno<2002


save "clean/rdip", replace
bysort anno: sum kb1y*


*--------------------------------------------------
* ALLB2 - SELF-EMPLOYED
*--------------------------------------------------

*use "raw/allb2_9814", clear
insheet using "raw/allb2_9814.csv", comma clear


rename prof kb2profaut

gen kb2nat=1
gen kb2prof=0 
gen kb2impr=0
gen kb2aut=0 
gen kb2atip=0

gen kb2yprof=0
gen kb2yimpr=0 
gen kb2yaut=0 
gen kb2yatip=0

la var kb2nat "Numero attivitࡤi lavoro indipendente"
la var kb2yprof "Liberi professionisti"
la var kb2yimpr "Imprenditori"
la var kb2yaut "Lavoratori autonomi"
la var kb2yatip "Lavoro atipico"

la var kb2yprof "Reddito netto Liberi professionisti"
la var kb2yimpr "Reddito netto Imprenditori"
la var kb2yaut "Reddito netto Lavoratori autonomi"
la var kb2yatip "Reddito netto Lavoro atipico"

* Calcolo del reddito netto 

replace kb2yprof=ym if kb2profaut==1
replace kb2prof=1 if kb2profaut==1
la var kb2prof "libero professionista"

replace kb2yimpr=ym if kb2profaut==2
replace kb2impr=1 if kb2profaut==2
la var kb2impr "imprenditore"

replace kb2yaut=ym if kb2profaut==3
replace kb2aut=1 if kb2profaut==3
la var kb2aut "lav autonomo" 

replace kb2yatip=ym if kb2profaut==4
replace kb2atip=1 if kb2profaut==4
la var kb2atip "lavoro atipico"

*ricoding missing
replace mesilav=12 if tuttanno==1
/*MESILAV missing when occasional job (TUTTANNO = 3)
It is necessary to establish a rule to impute MESILAV on these cases.
We impute 1 month*/
replace mesilav=1 if tuttanno==3
mvencode _all, mv(0) override

sort nquest nord anno


save "clean/allb2_temp", replace

*Building the individual file
/*It generates a file that aggregates the variables when the same subject has more than one activity */

*we generate the variable hours per year
gen hoursyear=0
replace hoursyear=mesilav*4*oretot

collapse (min) kb2profaut attivp /*debatt1 debatt2 debcom credcom*/ debcr1 debcr2 debcr3 debcr4 debcr5 immob (max) numadd numdip quopro /*ndebatt1 ndebatt2*/ (sum) kb2nat kb2prof kb2impr kb2aut kb2atip oretot hoursyear mesilav fatlor ym /*tdebcom tcredcom*/ tfr valaz kb2yprof kb2yimpr kb2yaut kb2yatip, by (nquest nord anno)

*ID for self-employed occupation
gen kb2=1
la var kb2 "Identificativo reddito lavoro indipendente"
*substitutes kb2 to allb2
*Attention: cases with more than 12 months of work !!
recode mesilav (13/max = 12)
sort nquest nord

*-------------RECODING-------------
la var attivp "attivitȠsvolta (indipendente)"
lab def attivp 1"Principale" 2"Secondaria", replace
lab val attivp attivp
rename attivp  kb2attivp


lab def kb2profaut 1"libero professionista" 2"imprenditore" 3"lav autonomo" 4"lavoro atipico"
la val kb2profaut  kb2profaut 


la var kb2prof "numero attivitࡤa libero professionista"
la var kb2impr "numero attivitࡤa imprenditore"
la var kb2aut "numero attivitࡤa lavoratore autonomo"
la var kb2atip "numero attivitࡤa lavoratore atipico"

la var kb2yprof "Reddito netto Liberi professionisti"
la var kb2yimpr "Reddito netto Imprenditori"
la var kb2yaut "Reddito netto Lavoratori autonomi"
la var kb2yatip "Reddito netto Lavoro atipico"

la var oretot "ore medie lavorate alla settimana"
rename oretot  kb2oretot
la var mesilav "mesi lavorati se meno di 12"
rename mesilav  kb2mesilav
la var numadd "numero di addetti nel'impresa"
rename numadd kb2numadd
la var numdip "numero dipendenti nell'imresa"
rename numdip kb2numdip
la var quopro "quota di proprietࡤella sua famiglia dell'impresa"
rename quopro kb2quopro
la var fatlor "ricavi e proventi lordi della sua attivitȠnel 2008"
rename fatlor kb2fatlor
la var ym "proventi netti della sua attivitȠnel 2008"
rename ym kb2ym
la var tfr "debito verso i lavoratori dipendenti per tfr"
rename tfr kb2tfr
la var immob "possesso immobili"
rename immob kb2immob
la var valaz "valore a cui protebbe cedere la sua azienda"
rename valaz kb2valaz
la var hoursyear "ore lavorate nell'anno (derivata)"
rename hoursyear kb2hoursyear


keep nquest nord anno kb2*
sort nquest nord anno
for varlist kb2y*: replace X=X/1.93627 if anno<2002

bysort anno: sum kb2y*
save "clean/raut", replace

/*merging panel component of SHIW 1998-2014*/
set more off
*use "raw/panel_9814_i", clear
insheet using "raw/panel_9814_i.csv", comma clear


merge 1:1 nquest nord anno using "clean/rdip"
drop _merge
merge 1:1 nquest nord anno using "clean/raut"
drop _merge



/*DUPLICATES: CHECK*/

duplicates drop pid anno, force
*convert the pre-2002 monetary values into EURO
 for varlist cn cd1 cd2 cd c s y* af* ar ar1* ar2 ar3 pf* w bd* impacq tmutuo* taxfis intpas wr tcredit tdebit*  mutuoin *tfit* valabit *tmanstra pr pr1 pr2 pr3 spesecon: replace X=X/1.93627 if anno<2002
for varlist kb1y*  kb2y* kb1hoursyear kb2hoursyear: recode X .=0
gen hoursyear=kb1hoursyear+kb2hoursyear
gen ylav=kb1ydip + kb1yfb + kb2ym + kb2yprof + kb2yimpr + kb2yaut + kb2yatip
gen wage=ylav/hoursyear


forvalues i=2(1)6{
sort anno nquest nord
gen ylav_`i' = ylav[_n+(`i'-1)] if nord==1 & nord[_n+(`i'-1)]==`i' & nquest==nquest[_n+(`i'-1)]
recode ylav_`i' .=0
}

forvalues i=2(1)6{
sort anno nquest nord
gen wage_`i' = wage[_n+(`i'-1)] if nord==1 & nord[_n+(`i'-1)]==`i' & nquest==nquest[_n+(`i'-1)]
recode wage_`i' .=0
}

forvalues i=2(1)6{
sort anno nquest nord
gen hoursyear_`i' = hoursyear[_n+(`i'-1)] if nord==1 & nord[_n+(`i'-1)]==`i' & nquest==nquest[_n+(`i'-1)]
recode hoursyear_`i' .=0
}
*/

/*generate OECD modified equivalence scale*/
gen pesocomp=(eta<14 & eta>=0)
recode pesocomp 1=0.3 0=0.5 // assegna peso 0.3 alle persone sotto i 14 anni e 0.5 a tutti gli altri
bys nquest anno: egen somma=sum(pesocomp)
gen ce=somma + 0.5 // aggiunge al peso 0.5 per tenere conto del capofamiglia
drop somma pesocomp

bys nquest anno: egen hourstot=sum(hoursyear)

/*sequivalence scale*/
gen minore16=eta<16
bysort nquest: egen minori16=sum(minore16)		
gen adulti=ncomp-minori16
gen check1=ncomp-(adulti+minori16)
tabstat check1, stats(mean)

/* Calcolo scala di equivalenza e variabili equivalenti */

gen eqsc=1+(0.7*(adulti-1))+(0.5*minori)

keep if nord==1

gen wave=1 if anno==1998
replace wave=2 if anno==2000
replace wave=3 if anno==2002
replace wave=4 if anno==2004
replace wave=5 if anno==2006
replace wave=6 if anno==2008
replace wave=7 if anno==2010
replace wave=8 if anno==2012
replace wave=9 if anno==2014

gen cn1=cn - yca2 - yl2
sum cn1[aw=peso], d

tsset pid wave
xtdes

/*
C Consumi totali
CN Consumi non durevoli
CN1 Consumi non durevoli monetari
CN2 Consumi non durevoli imputati (YL2+YCA2)
CD Spese per lӡcquisto di beni durevoli
CD1 Spesa per acquisto di mezzi di trasporto (al netto dei ricavi per le vendite)
CD2 Spesa per acquisto di altri beni durevoli
*/

gen dwage=(wage-l1.wage)/((wage+l1.wage)/2)
gen dhours=(hoursyear- l1.hoursyear)/((hoursyear+ l1.hoursyear)/2)


forvalues i=2(1)6{
gen dwage_`i'=(wage_`i'-l1.wage_`i')/((wage_`i'+l1.wage_`i')/2)
}

forvalues i=2(1)6{
gen dhours_`i'=(hoursyear_`i'-l1.hoursyear_`i')/((hoursyear_`i'+l1.hoursyear_`i')/2)

}

forvalues i=2(1)6{
gen dylav_`i'=(ylav_`i'-l1.ylav_`i')/((ylav_`i'+l1.ylav_`i')/2)
recode ylav_`i' .=0
}

gen dhours_other=dhours_2+dhours_3+dhours_4+dhours_5+dhours_6

gen dnperc=nperc-l1.nperc


save "clean/estimates_shiw", replace

*use "raw/ricf_archivio", replace
insheet using "raw/ricf_archivio.csv", comma clear

keep nquest anno *arch
save clean/temp, replace

merge 1:1 nquest anno using "clean/estimates_shiw"
keep if _merge==3
drop _merge

replace af= af_arch if anno==1998
replace af1= af1_arch if anno==1998
replace af2= af2_arch if anno==1998
replace af3= af3_arch if anno==1998



compress
save "clean/estimates_shiw", replace
*outsheet using "clean/estimates_shiw.csv", comma replace

erase clean/allb2_temp.dta
erase clean/temp.dta
erase clean/rdip.dta
erase clean/raut.dta
cd "${path}/shiw"


*DONE!

