program gmm_estimate, eclass
version 9.2

  #delim ;
  syntax [if] [in], x(varlist numeric) y(varname numeric) z(varlist numeric)
    i(varname) t(varname) [cluster(varname) center];
  #delim cr

  *warning: this trashes the data
  *preserve first

  if "`cluster'"~="" local cstr="cluster(`cluster')"


  *SETUP

  *variable names
  unab xx : `x'
  unab yy : `y'
  unab zz : `z'
  global MY_xnames "`xx'"
  global MY_yname "`yy'"
  global MY_znames "`zz'"
  global MY_K_x : word count `xx'
  global MY_K_z : word count `zz'

  *the sample, part 1
  marksample touse
  markout `touse' `t'
  markout `touse' `i', strok
  keep if `touse'

  *create lags
  qui tsset `i' `t'
  local lstr ""
  foreach v in `xx' `yy' {
    qui gen double L`v'=L.`v' if `touse'
    local lstr "`lstr' L`v'"
    }

  *the sample, part 2
  markout `touse' `x' `y' `z' `cluster' `lstr'
  keep if `touse'
  count
  global MY_N=r(N)

  *matrices we need
  tempname estcoeffs W
  global MY_gmmcoeffs `estcoeffs'
  global MY_gmmw `W'

  *organize the data
  sort `t'
  tempname tvals tfreqs
  qui tab1 `t', matcell(`tfreqs') matrow(`tvals')
  global MY_T = rowsof(`tfreqs')
  mat tbreaks=J($MY_T,2,.)
  mat tbreaks[1,1]=1
  mat tbreaks[1,2]=`tfreqs'[1,1]
  local k=`tvals'[1,1]
  local my_tlist "`k'"
  local my_parmlist "/del`k'"
  forvalues tt=2(1)$MY_T {
    local ttm=`tt'-1
    mat tbreaks[`tt',1]=tbreaks[`ttm',2]+1
    mat tbreaks[`tt',2]=tbreaks[`ttm',2]+`tfreqs'[`tt',1]
    local k=`tvals'[`tt',1]
    local my_tlist "`my_tlist' `k'"
    local my_parmlist "`my_parmlist' /del`k'"
    }
  global MY_tbreaks tbreaks
  global MY_tlist "`my_tlist'"


  *ESTIMATION

  tempname b1 b2 d1 d2 c1 c2 S1 S2 V1 V2e J1 J2

  *initial consistent estimator
  di _newline "initial consistent estimator"_c
  matrix $MY_gmmw=I(${MY_T}*(${MY_K_z}+1))
  #delim ;
  ml model d1 gmm_max `my_parmlist',
    collinear missing nopreserve noscvars technique(bfgs)
    max difficult;
  #delim cr
  matrix `d1'=e(b)
  matrix `c1'=$MY_gmmcoeffs
  scalar `J1'=-e(ll)

  *efficient weighting matrix
  #delim ;
  gmm_s2, d(`d1') s(`S1') t(`t') `cstr' `center' vcv(`V1')
    useoffset($MY_gmmuseoffset);
  #delim cr
  mat $MY_gmmw=invsym(`S1')

  *second-step efficient estimator
  di _newline "second-step efficient estimator"_c
  *note that to use a one-step theorem, we must start at result
  *from initial consistent estimator and do not search
  #delim ;
  ml model d1 gmm_max `my_parmlist',
    collinear missing nopreserve noscvars technique(bfgs)
    max difficult init(`d1') search(off);
  #delim cr
  matrix `d2'=e(b)
  scalar `J2'=-e(ll)
  matrix `c2'=$MY_gmmcoeffs
  gmm_s2, d(`d2') s(`S2') t(`t') `cstr' `center' vcv(`V2e') efficient useoffset($MY_gmmuseoffset)

  *clean up results

  *to avoid having equation names

  forvalues ii=1(1)2 {
    matrix `b`ii''=J(1,$MY_T,0)
    forvalues t=1(1)$MY_T {
      matrix `b`ii''[1,`t']=`d`ii''[1,`t']
      }
    matrix `b`ii''=(`b`ii'',`c`ii'')
    }

  local namestr ""
  foreach t in `my_tlist' {
    local namestr "`namestr' d_`t'"
    }
  foreach x in $MY_xnames {
    local namestr "`namestr' `x'"
    }
  mat colnames `b1' = `namestr'
  mat colnames `b2' = `namestr'
  mat rownames `V1' = `namestr'
  mat colnames `V1' = `namestr'
  mat rownames `V2e' = `namestr'
  mat colnames `V2e' = `namestr'

  tempname btemp
  mat `btemp'=`b2'

  ereturn clear
  ereturn post `btemp', esample(`touse')
  ereturn scalar N = $MY_N
  ereturn matrix b_initial = `b1'
  ereturn matrix vcv_initial = `V1'
  ereturn scalar objfun_initial = `J1'
  ereturn matrix b_efficient = `b2'
  ereturn matrix vcv_efficient = `V2e'
  ereturn scalar J_efficient = `J2'
  ereturn scalar moments = (${MY_K_z}+1)*${MY_T}
  ereturn scalar parameters = ${MY_T}+$MY_K_x
  ereturn scalar J_df = e(moments)-e(parameters)
  ereturn local cmd "gmm_estimate"

  drop `lstr'

end


