program factorreg_compute_iv
version 10.1

  syntax, d(name) f(name) g(name) y(varname) x(varname) z(varname)

  *the model here is y_it = a_i + d_t*b_i + f_t'theta_i + x_it*g + e_it
  * where f_t = kf x 1 is known (e.g. time trend)
  * f_t should be stored in f, a Txkf matrix
  * f_t should always contain a constant

  *we compute g by iv using z as instrument, removing the a_i, b_i and theta_i
  *by a quasi-fixed effects transformation

  *the necessary normalizations are d_1=1, sum_t d_t=0, and sum_t d_t*f_t=0

  *the transformation is	
  * Let d_i and F_i be the d vector and f matrix with zeros where i is not
  * observed.
  * Let M_i = I - iota_i * iota_i' / T_i
  * Let R_i = M_i - M_i * F_i * inv(F_i'*M_i*F_i) * F_i'*M_i
  * Let Q_i = R_i - R_i * d_i * d_i' * R_i / (d_i' * R_i * d_i)
  * then g = (sum_i z_i' * Q_i * y_i) / (sum_i z_i' Q_i x_i)
  * note that we can compute R_i beforehand since f is fixed

  *construct full d vector
  tempname q myd
  local kf=colsof(`f')
  local kfp1=`kf'+1
  local kfp2=`kf'+2
  if "`normb'"=="" {
    matrix `q'=-(`f'[1,1...]+`d'*`f'[`kfp2'...,1...])*inv(`f'[2..`kfp1',1...])
    matrix `myd'=(1,`q',`d')
    }
  else {
    matrix `q'=-(`f'[`kfp1',1...]+`d'*`f'[`kfp2'...,1...])*inv(`f'[1..`kf',1...])
    matrix `myd'=(`q',1,`d')
    }

  *calculate
  #delim ;
  mata: calc("`myd'","`y'","`x'","`z'","${MY_R_IV}",
             ${MY_N_IV},${MY_T_IV},"${MY_IV_ibreaks}","`g'");
  #delim cr

end


version 10.1
mata:
void calc(string scalar d, string scalar y, string scalar x, string scalar z,
  string R, real scalar N, real scalar T, string scalar ibreaks, string g)
  {

  dd=st_matrix(d)
  st_view(yy,.,y)
  st_view(xx,.,x)
  st_view(zz,.,z)
  st_view(RR,.,st_varindex(tokens(R)))
  breaks=st_matrix(ibreaks)

  Pxz=0
  Pyz=0
  Rd=RR*dd'

  for(i=1;i<=N;i++) {
    zblock=panelsubmatrix(zz,i,breaks)
    Rdi=panelsubmatrix(Rd,i,breaks)
    u=dd*Rdi
    if(u>1e-6) { 
      Q=panelsubmatrix(RR,i,breaks)-Rdi*Rdi'/u
      Pyz=Pyz+panelsubmatrix(yy,i,breaks)'*Q*zblock
      Pxz=Pxz+panelsubmatrix(xx,i,breaks)'*Q*zblock
      }
    else {
      Rblock=panelsubmatrix(RR,i,breaks)
      Pyz=Pyz+panelsubmatrix(yy,i,breaks)'*Rblock*zblock
      Pxz=Pxz+panelsubmatrix(xx,i,breaks)'*Rblock*zblock
      }
    }

  gg=Pyz/Pxz
  st_numscalar(g,gg)

  }
end
