program factorreg_compute
version 10.1

  #delim ;
  syntax, j(name) d(name) f(name)
    [g(name) negh(name) todo(integer 0) dout(name) NORMB];
  #delim cr

  *the model here is y_it = a_i + d_t*b_i + f_t'theta_i + x_it'beta + e_it
  * where f_t = kf x 1 is known (e.g. time trend)
  * f_t should be stored in f, a Txkf matrix
  * f_t should always contain a constant

  * we want to minimize the sum of squares by choice of a_i, b_i, theta_i, 
  * d_t, beta

  *the necessary normalizations are d_1=1, sum_t d_t=0, and sum_t d_t*f_t=0

  *note that given d_t, we have an analytic solution for everything else
  *specifically:
  * Let d_i and F_i be the d vector and f matrix with zeros where i is not
  * observed.
  * Let M_i = I - iota_i * iota_i' / T_i
  * Let R_i = M_i - M_i * F_i * inv(F_i'*M_i*F_i) * F_i'*M_i
  * Let Q_i = R_i - R_i * d_i * d_i' * R_i / (d_i' * R_i * d_i)
  * then betahat = inv(sum_i X_i' * Q_i * X_i) * sum_i X_i' Q_i y_i
  * and minimizing the sum of squares is equivalent to maximizing
  * P_xy' * inv(P_xx) * P_xy - YY where
  * P_xy = sum_i X_i' Q_i y_i 
  * P_xx = sum_i X_i' Q_i X_i
  * YY = sum_i y_i' Q_i y_i
  * note that we can compute R_i beforehand
  * so what we have to do here is just construct Q_i, P_xy, P_xx, YY.
  * in fact, we can be even more efficient:
  * y_i' Q_i y_i = y_i' R_i y_i - (y_i'*R_i*d_i)^2/d_i'*R_i*d_i) 
  * X_i' Q_i X_i = X_i' R_i X_i - X_i'R_i*(d_i*d_i'/d_i'*R_i*d_i)*R_i*X_i
  * X_i' Q_i y_i = X_i' R_i y_i - X_i'R_i*d_i * (y_i'R_i*d_i) / d_i'*R_i*d_i
  * so we can construct R_i y_i (Tx1)
  * and R_i X_i (TxKx) beforehand

  *construct full d vector
  tempname q myd
  local kf=colsof(`f')
  local kfp1=`kf'+1
  local kfp2=`kf'+2
  if "`normb'"=="" {
    matrix `q'=-(`f'[1,1...]+`d'*`f'[`kfp2'...,1...])*inv(`f'[2..`kfp1',1...])
    matrix `myd'=(1,`q',`d')
    }
  else {
    matrix `q'=-(`f'[`kfp1',1...]+`d'*`f'[`kfp2'...,1...])*inv(`f'[1..`kf',1...])
    matrix `myd'=(`q',1,`d')
    }

  *return error if d is very large
  tempname testmat
  mat `testmat'=`myd'*`myd''
  if `testmat'[1,1]>(($MY_T-`kfp1')*1e6) {
    scalar `j'=.
    if `todo'==1 | `todo'==2 matrix `g'=J(1,colsof(`d'),.)
    if `todo'==2 matrix `negh'=J(colsof(`d'),colsof(`d'),.)
    }

  *calculate
  else {

    local nx : word count $MY_xnames 

    tempname glong hlong
    #delim ;
    mata: calc("`myd'","${MY_yname}","${MY_xnames}","${MY_R}",
               "${MY_Ry}","${MY_yRRy}","${MY_Rx}","${MY_XRRX}","${MY_yRRX}",
               ${MY_N}, 
               "${MY_ibreaks}","`j'","${MY_factorregcoeffs}",
               "`glong'","`hlong'",`todo',`nx');
    #delim cr

    if `todo'==1 | `todo'==2 {
      *glong is derivative wrt entire myd vector
      *we want only the parts in d, so must keep track of normalization
      tempname ddlong_dd
      #delim ;
      if "`normb'"=="" {;
        matrix `ddlong_dd'
          = ( J(1,${MY_T}-`kfp1',0) \
              -inv(`f'[2..`kfp1',1..`kf'])'*`f'[`kfp2'...,1...]' \
              I(${MY_T}-`kfp1') );
        };
      else {;
        matrix `ddlong_dd'
          = ( -inv(`f'[1..`kf',1..`kf'])'*`f'[`kfp2'...,1...]' \
              J(1,${MY_T}-`kfp1',0) \
              I(${MY_T}-`kfp1') );
        };
      #delim cr
      matrix `g'=`glong'*`ddlong_dd'
      if `todo'==2 {
        matrix `negh'=`ddlong_dd''*`hlong'*`ddlong_dd'
        *symmetrize
        matrix `negh'=0.5*(`negh'+`negh'')
        }       
      }

    if "`dout'"~="" {
      matrix `dout'=J(1,${MY_T},.)
      local dlabels ""
      forvalues t=1(1)$MY_T {
        matrix `dout'[1,`t']=`myd'[1,`t']
        local dlabels "`dlabels' d`t'"
        }
      mat colnames `dout' = `dlabels'
      mat rownames `dout' = d
      }

    }

end


version 10.1
mata:
void calc(string scalar d, string scalar y, string X, string R,
  string scalar Ry, string scalar yRRy, string RX,
  string scalar XRRX, string scalar yRRX,
  real scalar N, string scalar ibreaks,
  string scalar f, string scalar coeffs,
  string scalar g, string scalar h, real scalar todo, real scalar Kx)
  {
  dd=st_matrix(d)
  st_view(yy,.,y)
  st_view(RRy,.,Ry)
  st_view(RR,.,st_varindex(tokens(R)))
  breaks=st_matrix(ibreaks)
  if(Kx>0) {
    st_view(XX,.,st_varindex(tokens(X)))
    st_view(RRX,.,st_varindex(tokens(RX)))
    Pxx=st_matrix(XRRX)
    Pxy=st_matrix(yRRX)
    }
  ysum=st_numscalar(yRRy)
  Rd=RR*dd'
  for(i=1;i<=N;i++) {
    u=dd*panelsubmatrix(Rd,i,breaks)
    if(u>1e-6) { 
      v1=dd*panelsubmatrix(RRy,i,breaks)
      ysum=ysum-v1'*v1/u
      if(Kx>0) {
        v2=dd*panelsubmatrix(RRX,i,breaks)
        Pxx=Pxx-v2'*v2/u
        Pxy=Pxy-v1'*v2/u
        }
      } 
    }
  if(Kx>0) {
    ccoeffs=Pxy*invsym(Pxx)
    st_matrix(coeffs,ccoeffs)
    ff=ccoeffs*Pxy'-ysum
    }
  else ff=-ysum
  st_numscalar(f,ff)

  if(todo==1|todo==2) {
    gg=J(cols(dd),1,0)
    if(todo==2) hh=J(cols(dd),cols(dd),0)
    for(i=1;i<=N;i++) {
      Rdi=panelsubmatrix(Rd,i,breaks)
      u=dd*Rdi
      if(u>1e-6) { 
        if(Kx>0) {
          v1=panelsubmatrix(yy,i,breaks)-panelsubmatrix(XX,i,breaks)*ccoeffs'
          }
        else v1=panelsubmatrix(yy,i,breaks)
        w=(v1'*Rdi)/u
        Rblock=panelsubmatrix(RR,i,breaks)
        gg=gg+w*Rblock*(v1-w*dd')
        if(todo==2) {
          v2=Rblock*(v1-2*w*dd') 
          hh=hh-w*w*Rblock + v2*v2'/u
          }
        }
      }
    gg=2*gg'
    st_matrix(g,gg)
    if(todo==2) {
      hh=-2*hh
      st_matrix(h,hh)
      }
    }

  }
end
