/* Patrick Arni, Rafael Lalive and Jan C. van Ours, "How Effective are Unemployment Benefit Sanctions? Looking Beyond Unemployment Exit"
, Journal of Applied Econometrics, Vol..., No..., 2012, pp. ...		*/



****** Simulations of expected post-ue earnings and unemployment durations, for the treated and non-treated counterfactuals ******
	   **** See technical online appendix for details ****

use sim_values.dta, clear

/* The following variables are provided as input for simulations:

adur		int		duration from entry to warning
warn		byte	=1 if warned
yp24		byte	Y>0 group: =1 if sum of earnings over 24mt > 0 (& duration not censored)
y024		byte	Y=0 group: =1 if sum of earnings over 24mt = 0 (& duration not censored)
Ds2			byte	=1 if enforcement observed (enf=1) or if simulation of enforcement duration yields an enforcement (if dur<aedurS2<720)
aedurS2		int		for [warn=1&enf=0]: simulated dur to enforcement; for [warn=1&enf=1]: observed duration to enforcement
xbe			float	prediction x'beta based on parameters from exit Y>0 process estimation
xbne		float	prediction x'beta based on parameters from exit Y=0 process estimation
xbe24		float	prediction x'beta based on parameters from earnings process estimation
p_ty_a		float	Prob(v_a|Ty = ty, T0 > ty): unobs.het.cond.on exit to Y>0 (see p.22),non-treated
p_ty_b		float	Prob(v_b|Ty = ty, T0 > ty): unobs.het.cond.on exit to Y>0 (see p.22),non-treated
pt_ty_a		float	Prob(v_a|Ty = ty, T0 > ty): unobs.het.cond.on exit to Y>0 (see p.22),treated
pt_ty_b		float	Prob(v_b|Ty = ty, T0 > ty): unobs.het.cond.on exit to Y>0 (see p.22),treated

[Note that the last four probability weights have been generated in a further simulation of the distribution of t_y, for treated and non-treated counterfactuals, respectively.]
*/



**** Simulation of expected earnings counterfactuals (based on  Model III, group Y24>0)


*** fix scalars: lambdas (baseline hazard of earnings distribution) and treatment effects

scalar LE24B = -6.84996
scalar LE24A = -4.69602
scalar LE241 = 1.35822
scalar LE242 = 2.81583
scalar LE243 = 3.50141
scalar D24Y1 = 0.11669
scalar D24Y2 = 0.103723
scalar list


*** Y1) Calculate E(Y^0|D=1) (i.e. the non-treatment counterfactual (for the treated))

** Simulate y*f(y) at earnings values 1 to 200 (1000 CHF steps, like in estimation) for each individual (i.e. E_v[S(y|v)theta(y|v)] for y=1,...,200)

quietly{
forvalues j=1(1)200 {
scalar yy0=max(min(50,`j'), 0)
scalar yy1=max(min(50,(`j'-50)) ,0)
scalar yy2=max(min(50,(`j'-100)), 0) 
scalar yy3=max((`j'-150),0) 
*disp yy0
*disp yy1
*disp yy2
*disp yy3
scalar dyy1=cond((`j'>50 & `j'<=100),1,0)
scalar dyy2=cond((`j'>100 & `j'<=150),1,0)
scalar dyy3=cond(`j'>150,1,0)
*disp `j'
*disp dyy1
*disp dyy2
*disp dyy3

g lnsurv_a=exp(xbe24)*exp(LE24A)*(yy0 + yy1*exp(LE241) + yy2*exp(LE242) + yy3*exp(LE243))
g lnsurv_b=exp(xbe24)*exp(LE24B)*(yy0 + yy1*exp(LE241) + yy2*exp(LE242) + yy3*exp(LE243))
g surv_a=exp((-1)*lnsurv_a)
g surv_b=exp((-1)*lnsurv_b)
g haz_a=exp(xbe24 + LE24A + dyy1*LE241 + dyy2*LE242 + dyy3*LE243)
g haz_b=exp(xbe24 + LE24B + dyy1*LE241 + dyy2*LE242 + dyy3*LE243)

g f`j' = p_ty_a*haz_a*surv_a + p_ty_b*haz_b*surv_b  // weights: given that people enter Y>0 group (Ty=ty,T0>ty)

drop lnsurv_a lnsurv_b surv_a surv_b haz_a haz_b
compress
}
}

** calculate formula (13):
* integrate/sum up evaluated y*f(y):
g y_fy=0
quietly{
forvalues v=1(1)200{
replace y_fy=y_fy+`v'*f`v'
}
}
* integrate/sum up f(y): 
g fy_tot=0
quietly{
forvalues v=1(1)199{
replace fy_tot=fy_tot+f`v'
}
}
* combine:
g Eyfy=y_fy+(1-fy_tot)*200


** sum over individuals and average (i.e. E_x(Y|x)=E(Y))
sum Eyfy if warn==1 & yp24==1	// expected earnings (of the treated) for the non-treated counterfactual

rename Eyfy Eyfy_NT
drop f1 - fy_tot


*** Y2) Calculate E(Y^1|D=1) (i.e. the treatment counterfactual (for the treated))

** Simulate y*f(y) at earnings values 1 to 200 (1000 CHF steps, like in estimation) for each individual (i.e. E_v[S(y|v)theta(y|v)] for y=1,...,200)


quietly{
forvalues j=1(1)200 {
scalar yy0=max(min(50,`j'), 0)
scalar yy1=max(min(50,(`j'-50)) ,0)
scalar yy2=max(min(50,(`j'-100)), 0) 
scalar yy3=max((`j'-150),0) 
*disp yy0
*disp yy1
*disp yy2
*disp yy3
scalar dyy1=cond((`j'>50 & `j'<=100),1,0)
scalar dyy2=cond((`j'>100 & `j'<=150),1,0)
scalar dyy3=cond(`j'>150,1,0)
*disp `j'
*disp dyy1
*disp dyy2
*disp dyy3
g lnsurv_a=exp(xbe24)*exp(D24Y1+Ds2*D24Y2)*exp(LE24A)*(yy0 + yy1*exp(LE241) + yy2*exp(LE242) + yy3*exp(LE243))
g lnsurv_b=exp(xbe24)*exp(D24Y1+Ds2*D24Y2)*exp(LE24B)*(yy0 + yy1*exp(LE241) + yy2*exp(LE242) + yy3*exp(LE243))
g surv_a=exp((-1)*lnsurv_a)
g surv_b=exp((-1)*lnsurv_b)
g haz_a=exp(xbe24 + LE24A + dyy1*LE241 + dyy2*LE242 + dyy3*LE243 + D24Y1+Ds2*D24Y2)
g haz_b=exp(xbe24 + LE24B + dyy1*LE241 + dyy2*LE242 + dyy3*LE243 + D24Y1+Ds2*D24Y2)

g f`j' = pt_ty_a*haz_a*surv_a + pt_ty_b*haz_b*surv_b   // weights: given that people enter Y>0 group (Ty=ty,T0>ty)

drop lnsurv_a lnsurv_b surv_a surv_b haz_a haz_b
compress
}
}

** calculate formula (13):
* integrate/sum up evaluated y*f(y):
g y_fy=0
quietly{
forvalues v=1(1)200{
replace y_fy=y_fy+`v'*f`v'
}
}
* integrate/sum up f(y): 
g fy_tot=0
quietly{
forvalues v=1(1)199{
replace fy_tot=fy_tot+f`v'
}
}
* combine:
g Eyfy=y_fy+(1-fy_tot)*200


** sum over individuals and average (i.e. E_x(Y|x)=E(Y))
sum Eyfy if warn==1 & yp24==1	// expected earnings (of the treated) for the treated counterfactual

rename Eyfy Eyfy_T
drop f1 - fy_tot


** Treatment Effect: Difference of means (in 1000 CHF)
sum Eyfy_T Eyfy_NT if warn==1 & yp24==1




**** Simulation of expected unemployment duration counterfactuals (based on  Model III), group exit to Y24>0


*** fix scalars: probability weights (at t_0), lambdas (baseline hazards of t0- and ty- duration distributions) and treatment effects

scalar p_aa =	0.4604724	// prob weight for uo.het. group aa (first suffix: exit to Y24>0, second suffix: exit to Y24=0)
scalar p_ab =	0.4076165
scalar p_ba =	0.1004259
scalar p_bb =	0.0314852

scalar LEB = -5.88711
scalar LEA = -4.79724
scalar LE1 = 0.860764
scalar LE2 = 0.830375
scalar LE3 = 0.766517

scalar DY1 = 0.18062
scalar DY2 = 0.210784

scalar LNEB	= -2.81198
scalar LNEA = -4.78453
scalar LNE1	= 0.899809
scalar LNE2	= 1.30827
scalar LNE3	= 1.43185

scalar DNY1 = 0.830187
scalar DNY2	= 0.294136
scalar list



*** T1) Calculate E(T_y^0|D=1) (i.e. the non-treatment counterfactual (for the treated))

** Simulate t*f(t) at ue duration values 1 to 720 (1 day steps, like in estimation) for each individual (i.e. E_v(theta_e(t|v)S_e(t|v)S_ne(t|v)) for y=1,...,720)

g s_tw_aa=.
g s_tw_ab=.
g s_tw_ba=.
g s_tw_bb=.
g p_tw_aa=.
g p_tw_ab=.
g p_tw_ba=.
g p_tw_bb=.

quietly{
forvalues j=1(1)720 {
scalar nse0=max(min(40,`j'), 0)
scalar nse1=max(min(170,(`j'-40)) ,0)
scalar nse2=max(min(150,(`j'-210)), 0) 
scalar nse3=max((`j'-360),0) 
scalar nsn0=max(min(90,`j'), 0)
scalar nsn1=max(min(180,(`j'-90)) ,0)
scalar nsn2=max(min(210,(`j'-270)), 0) 
scalar nsn3=max((`j'-480),0)
scalar dtt1=cond((`j'>40 & `j'<=210),1,0)
scalar dtt2=cond((`j'>210 & `j'<=360),1,0)
scalar dtt3=cond(`j'>360,1,0)
*disp `j'
*disp dtt1
*disp dtt2
*disp dtt3
g lnsurve_a=exp(xbe)*exp(LEA)*(nse0 + nse1*exp(LE1) + nse2*exp(LE2) + nse3*exp(LE3))
g lnsurve_b=exp(xbe)*exp(LEB)*(nse0 + nse1*exp(LE1) + nse2*exp(LE2) + nse3*exp(LE3))
g surve`j'_a=exp((-1)*lnsurve_a)
g surve`j'_b=exp((-1)*lnsurve_b)
g lnsurvne_a=exp(xbne)*exp(LNEA)*(nsn0 + nsn1*exp(LNE1) + nsn2*exp(LNE2) + nsn3*exp(LNE3))
g lnsurvne_b=exp(xbne)*exp(LNEB)*(nsn0 + nsn1*exp(LNE1) + nsn2*exp(LNE2) + nsn3*exp(LNE3))
g survne`j'_a=exp((-1)*lnsurvne_a)
g survne`j'_b=exp((-1)*lnsurvne_b)

g haz_a=exp(xbe + LEA + dtt1*LE1 + dtt2*LE2 + dtt3*LE3 )
g haz_b=exp(xbe + LEB + dtt1*LE1 + dtt2*LE2 + dtt3*LE3 )

g f`j'_aa=haz_a*surve`j'_a*survne`j'_a
g f`j'_ab=haz_a*surve`j'_a*survne`j'_b
g f`j'_ba=haz_b*surve`j'_b*survne`j'_a
g f`j'_bb=haz_b*surve`j'_b*survne`j'_b

replace f`j'_aa=0 if `j'<adur	// conditional on being treated: no exits before tw (see p.22 bottom)
replace f`j'_ab=0 if `j'<adur
replace f`j'_ba=0 if `j'<adur
replace f`j'_bb=0 if `j'<adur


** generate Prob(Ty>tw,T0>tw)=S_y(tw)*S_0(tw) for cond. uo.het. probability weights (see p.23)
replace s_tw_aa=surve`j'_a*survne`j'_a if `j'==adur  // store S_y(tw)*S_0(tw) for every individual (given v_aa)
replace s_tw_ab=surve`j'_a*survne`j'_b if `j'==adur  // store S_y(tw)*S_0(tw) for every individual (given v_ab)
replace s_tw_ba=surve`j'_b*survne`j'_a if `j'==adur  // store S_y(tw)*S_0(tw) for every individual (given v_ba)
replace s_tw_bb=surve`j'_b*survne`j'_b if `j'==adur  // store S_y(tw)*S_0(tw) for every individual (given v_bb)


drop lnsurve_a lnsurve_b  lnsurvne_a lnsurvne_b haz_a haz_b  surve`j'_a surve`j'_b survne`j'_a survne`j'_b 
compress
}
}

** generate uo.het. probability weights conditional on being warned (treated): Prob(v_aa|T>tw), Prob(v_ab|T>tw)  etc.
replace p_tw_aa= (s_tw_aa * p_aa)/(s_tw_aa*p_aa+s_tw_ab*p_ab+s_tw_ba*p_ba+s_tw_bb*p_bb)   // Bayesian formula to calc Prob(v_aa|T>tw)
replace p_tw_ab= (s_tw_ab * p_ab)/(s_tw_aa*p_aa+s_tw_ab*p_ab+s_tw_ba*p_ba+s_tw_bb*p_bb)   // Bayesian formula to calc Prob(v_ab|T>tw)
replace p_tw_ba= (s_tw_ba * p_ba)/(s_tw_aa*p_aa+s_tw_ab*p_ab+s_tw_ba*p_ba+s_tw_bb*p_bb)   // Bayesian formula to calc Prob(v_ba|T>tw)
replace p_tw_bb= (s_tw_bb * p_bb)/(s_tw_aa*p_aa+s_tw_ab*p_ab+s_tw_ba*p_ba+s_tw_bb*p_bb)   // Bayesian formula to calc Prob(v_bb|T>tw)


** integrate t*f(t): sum up evaluated theta_e(t)*S_e(t)*S_ne(t) from 0 to 720
g ft_aa=0
g t_ft_aa=0
g ft_ab=0
g t_ft_ab=0
g ft_ba=0
g t_ft_ba=0
g ft_bb=0
g t_ft_bb=0

quietly{
forvalues v=1(1)720{
replace ft_aa=ft_aa+f`v'_aa
replace t_ft_aa=t_ft_aa+`v'*f`v'_aa
replace ft_ab=ft_ab+f`v'_ab
replace t_ft_ab=t_ft_ab+`v'*f`v'_ab
replace ft_ba=ft_ba+f`v'_ba
replace t_ft_ba=t_ft_ba+`v'*f`v'_ba
replace ft_bb=ft_bb+f`v'_bb
replace t_ft_bb=t_ft_bb+`v'*f`v'_bb
}
}
** calculate formula (15):
g Etft=p_tw_aa*(t_ft_aa/ft_aa)+p_tw_ab*(t_ft_ab/ft_ab)+p_tw_ba*(t_ft_ba/ft_ba)+p_tw_bb*(t_ft_bb/ft_bb)


** sum over individuals and average (i.e. E_x(Y|x)=E(Y))
sum Etft if warn==1 & yp24==1	// expected unemployment duration (of the treated) for the non-treated counterfactual

rename Etft Etft_NT
drop s_tw_aa- t_ft_bb




*** T2) Calculate E(T_y^1|D=1) (i.e. the treatment counterfactual (for the treated))

** Simulate t*f(t) at ue duration values 1 to 720 (1 day steps, like in estimation) for each individual (i.e. E_v(theta_e(t|v)S_e(t|v)S_ne(t|v)) for y=1,...,720)

g st_tw_aa=.
g st_tw_ab=.
g st_tw_ba=.
g st_tw_bb=.
g pt_tw_aa=.
g pt_tw_ab=.
g pt_tw_ba=.
g pt_tw_bb=.

quietly{
forvalues j=1(1)720 {
scalar nse0=max(min(40,`j'), 0)
scalar nse1=max(min(170,(`j'-40)) ,0)
scalar nse2=max(min(150,(`j'-210)), 0) 
scalar nse3=max((`j'-360),0) 
scalar nsn0=max(min(90,`j'), 0)
scalar nsn1=max(min(180,(`j'-90)) ,0)
scalar nsn2=max(min(210,(`j'-270)), 0) 
scalar nsn3=max((`j'-480),0)
scalar dtt1=cond((`j'>40 & `j'<=210),1,0)
scalar dtt2=cond((`j'>210 & `j'<=360),1,0)
scalar dtt3=cond(`j'>360,1,0)
*disp `j'
*disp dtt1
*disp dtt2
*disp dtt3

g ttea0=max(min((`j'-adur),(40-adur)), 0)
g ttea1=max(min(170,(`j'-adur),(`j'-40),(210-adur)), 0) 
g ttea2=max(min(150,(`j'-adur),(`j'-210),(360-adur)), 0)
g ttea3=max(min((`j'-360),(`j'-adur)), 0)
g tteae0=max(min((`j'-aedurS2),(40-aedurS2)), 0)
g tteae1=max(min(170,(`j'-aedurS2),(`j'-40),(210-aedurS2)), 0)
g tteae2=max(min(150,(`j'-aedurS2),(`j'-210),(360-aedurS2)), 0)
g tteae3=max(min((`j'-360),(`j'-aedurS2)), 0)
*list ttea0- tteae3

g ttna0=max(min((`j'-adur),(90-adur)), 0)
g ttna1=max(min(180,(`j'-adur),(`j'-90),(270-adur)), 0) 
g ttna2=max(min(210,(`j'-adur),(`j'-270),(480-adur)), 0)
g ttna3=max(min((`j'-480),(`j'-adur)), 0)
g ttnae0=max(min((`j'-aedurS2),(90-aedurS2)), 0)
g ttnae1=max(min(180,(`j'-aedurS2),(`j'-90),(270-aedurS2)), 0)
g ttnae2=max(min(210,(`j'-aedurS2),(`j'-270),(480-aedurS2)), 0)
g ttnae3=max(min((`j'-480),(`j'-aedurS2)), 0)

#delimit ;
g lnsurve_a=exp(xbe)*exp(LEA)*((nse0 + nse1*exp(LE1) + nse2*exp(LE2) + nse3*exp(LE3))
		+ (exp(DY1)-1)*(ttea0 + ttea1*exp(LE1) + ttea2*exp(LE2) + ttea3*exp(LE3))
		+ (exp(DY1+DY2)-exp(DY1))*(tteae0 + tteae1*exp(LE1) + tteae2*exp(LE2) + tteae3*exp(LE3))); 
g lnsurve_b=exp(xbe)*exp(LEB)*((nse0 + nse1*exp(LE1) + nse2*exp(LE2) + nse3*exp(LE3))
		+ (exp(DY1)-1)*(ttea0 + ttea1*exp(LE1) + ttea2*exp(LE2) + ttea3*exp(LE3))
		+ (exp(DY1+DY2)-exp(DY1))*(tteae0 + tteae1*exp(LE1) + tteae2*exp(LE2) + tteae3*exp(LE3)));
#delimit cr
g surve`j'_a=exp((-1)*lnsurve_a)
g surve`j'_b=exp((-1)*lnsurve_b)

#delimit ;
g lnsurvne_a=exp(xbne)*exp(LNEA)*((nsn0 + nsn1*exp(LNE1) + nsn2*exp(LNE2) + nsn3*exp(LNE3))
		+ (exp(DNY1)-1)*(ttna0 + ttna1*exp(LNE1) + ttna2*exp(LNE2) + ttna3*exp(LNE3))
		+ (exp(DNY1+DNY2)-exp(DNY1))*(ttnae0 + ttnae1*exp(LNE1) + ttnae2*exp(LNE2) + ttnae3*exp(LNE3)));
g lnsurvne_b=exp(xbne)*exp(LNEB)*((nsn0 + nsn1*exp(LNE1) + nsn2*exp(LNE2) + nsn3*exp(LNE3))
		+ (exp(DNY1)-1)*(ttna0 + ttna1*exp(LNE1) + ttna2*exp(LNE2) + ttna3*exp(LNE3))
		+ (exp(DNY1+DNY2)-exp(DNY1))*(ttnae0 + ttnae1*exp(LNE1) + ttnae2*exp(LNE2) + ttnae3*exp(LNE3)));
#delimit cr
g survne`j'_a=exp((-1)*lnsurvne_a)
g survne`j'_b=exp((-1)*lnsurvne_b)

g war_t=(warn==1 & `j'>adur)   //** only correct for warned people
g enf_t=(warn==1 & `j'>aedurS2)  //** works for warn=1 people; simulated enf'dur used, aedurS2

g haz_a=exp(xbe + LEA + dtt1*LE1 + dtt2*LE2 + dtt3*LE3 + war_t*DY1 + enf_t*DY2)
g haz_b=exp(xbe + LEB + dtt1*LE1 + dtt2*LE2 + dtt3*LE3 + war_t*DY1 + enf_t*DY2)

g f`j'_aa=haz_a*surve`j'_a*survne`j'_a
g f`j'_ab=haz_a*surve`j'_a*survne`j'_b
g f`j'_ba=haz_b*surve`j'_b*survne`j'_a
g f`j'_bb=haz_b*surve`j'_b*survne`j'_b

replace f`j'_aa=0 if `j'<adur
replace f`j'_ab=0 if `j'<adur
replace f`j'_ba=0 if `j'<adur
replace f`j'_bb=0 if `j'<adur


** generate Prob(Ty>tw,T0>tw)=S_y(tw)*S_0(tw) for cond. uo.het. probability weights (see p.23)
replace st_tw_aa=surve`j'_a*survne`j'_a if `j'==adur  // store S_y(tw)*S_0(tw) for every individual (given v_aa)
replace st_tw_ab=surve`j'_a*survne`j'_b if `j'==adur  // store S_y(tw)*S_0(tw) for every individual (given v_ab)
replace st_tw_ba=surve`j'_b*survne`j'_a if `j'==adur  // store S_y(tw)*S_0(tw) for every individual (given v_ba)
replace st_tw_bb=surve`j'_b*survne`j'_b if `j'==adur  // store S_y(tw)*S_0(tw) for every individual (given v_bb)


drop ttea0- tteae3 ttna0- ttnae3 lnsurve_a lnsurve_b surve`j'_a surve`j'_b lnsurvne_a lnsurvne_b survne`j'_a survne`j'_b haz_a haz_b war_t enf_t
compress
}
}

** generate uo.het. probability weights conditional on being warned (treated): Prob(v_aa|T>tw), Prob(v_ab|T>tw)  etc.
replace pt_tw_aa= (st_tw_aa * p_aa)/(st_tw_aa*p_aa+st_tw_ab*p_ab+st_tw_ba*p_ba+st_tw_bb*p_bb)   // Bayesian formula to calc Prob(v_aa|T>tw)
replace pt_tw_ab= (st_tw_ab * p_ab)/(st_tw_aa*p_aa+st_tw_ab*p_ab+st_tw_ba*p_ba+st_tw_bb*p_bb)   // Bayesian formula to calc Prob(v_ab|T>tw)
replace pt_tw_ba= (st_tw_ba * p_ba)/(st_tw_aa*p_aa+st_tw_ab*p_ab+st_tw_ba*p_ba+st_tw_bb*p_bb)   // Bayesian formula to calc Prob(v_ba|T>tw)
replace pt_tw_bb= (st_tw_bb * p_bb)/(st_tw_aa*p_aa+st_tw_ab*p_ab+st_tw_ba*p_ba+st_tw_bb*p_bb)   // Bayesian formula to calc Prob(v_bb|T>tw)


** integrate t*f(t): sum up evaluated theta_e(t)*S_e(t)*S_ne(t) from 0 to 720
g ft_aa=0
g t_ft_aa=0
g ft_ab=0
g t_ft_ab=0
g ft_ba=0
g t_ft_ba=0
g ft_bb=0
g t_ft_bb=0

quietly{
forvalues v=1(1)720{
replace ft_aa=ft_aa+f`v'_aa
replace t_ft_aa=t_ft_aa+`v'*f`v'_aa
replace ft_ab=ft_ab+f`v'_ab
replace t_ft_ab=t_ft_ab+`v'*f`v'_ab
replace ft_ba=ft_ba+f`v'_ba
replace t_ft_ba=t_ft_ba+`v'*f`v'_ba
replace ft_bb=ft_bb+f`v'_bb
replace t_ft_bb=t_ft_bb+`v'*f`v'_bb
}
}
** calculate formula (14):
g Etft=pt_tw_aa*(t_ft_aa/ft_aa)+pt_tw_ab*(t_ft_ab/ft_ab)+pt_tw_ba*(t_ft_ba/ft_ba)+pt_tw_bb*(t_ft_bb/ft_bb)


** sum over individuals and average (i.e. E_x(Y|x)=E(Y))
sum Etft if warn==1 & yp24==1	// expected unemployment duration (of the treated) for the non-treated counterfactual

rename Etft Etft_T
drop st_tw_aa- t_ft_bb


** Treatment Effect: Difference of means (in days of unemployment)
sum Etft_T Etft_NT if warn==1 & yp24==1






**** Simulation of expected unemployment duration counterfactuals (based on  Model III), group exit to Y24=0


*** T3) Calculate E(T_0^0|D=1) (i.e. the non-treatment counterfactual (for the treated))

** Simulate t*f(t) at ue duration values 1 to 720 (1 day steps, like in estimation) for each individual (i.e. E_v(theta_e(t|v)S_e(t|v)S_ne(t|v)) for y=1,...,720)

g sn_tw_aa=.
g sn_tw_ab=.
g sn_tw_ba=.
g sn_tw_bb=.
g pn_tw_aa=.
g pn_tw_ab=.
g pn_tw_ba=.
g pn_tw_bb=.

quietly{
forvalues j=1(1)720 {
scalar nse0=max(min(40,`j'), 0)
scalar nse1=max(min(170,(`j'-40)) ,0)
scalar nse2=max(min(150,(`j'-210)), 0) 
scalar nse3=max((`j'-360),0) 
scalar nsn0=max(min(90,`j'), 0)
scalar nsn1=max(min(180,(`j'-90)) ,0)
scalar nsn2=max(min(210,(`j'-270)), 0) 
scalar nsn3=max((`j'-480),0)
scalar dtt1=cond((`j'>90 & `j'<=270),1,0)
scalar dtt2=cond((`j'>270 & `j'<=480),1,0)
scalar dtt3=cond(`j'>480,1,0)
*disp `j'
*disp dtt1
*disp dtt2
*disp dtt3
g lnsurve_a=exp(xbe)*exp(LEA)*(nse0 + nse1*exp(LE1) + nse2*exp(LE2) + nse3*exp(LE3))
g lnsurve_b=exp(xbe)*exp(LEB)*(nse0 + nse1*exp(LE1) + nse2*exp(LE2) + nse3*exp(LE3))
g surve`j'_a=exp((-1)*lnsurve_a)
g surve`j'_b=exp((-1)*lnsurve_b)
g lnsurvne_a=exp(xbne)*exp(LNEA)*(nsn0 + nsn1*exp(LNE1) + nsn2*exp(LNE2) + nsn3*exp(LNE3))
g lnsurvne_b=exp(xbne)*exp(LNEB)*(nsn0 + nsn1*exp(LNE1) + nsn2*exp(LNE2) + nsn3*exp(LNE3))
g survne`j'_a=exp((-1)*lnsurvne_a)
g survne`j'_b=exp((-1)*lnsurvne_b)

g hazn_a=exp(xbne + LNEA + dtt1*LNE1 + dtt2*LNE2 + dtt3*LNE3 )
g hazn_b=exp(xbne + LNEB + dtt1*LNE1 + dtt2*LNE2 + dtt3*LNE3 )

g f`j'_aa=hazn_a*surve`j'_a*survne`j'_a
g f`j'_ab=hazn_b*surve`j'_a*survne`j'_b
g f`j'_ba=hazn_a*surve`j'_b*survne`j'_a
g f`j'_bb=hazn_b*surve`j'_b*survne`j'_b
							
replace f`j'_aa=0 if `j'<adur
replace f`j'_ab=0 if `j'<adur
replace f`j'_ba=0 if `j'<adur
replace f`j'_bb=0 if `j'<adur


** generate Prob(Ty>tw,T0>tw)=S_y(tw)*S_0(tw) for cond. uo.het. probability weights (see p.23)
replace sn_tw_aa=surve`j'_a*survne`j'_a if `j'==adur  // store S_y(tw)*S_0(tw) for every individual (given v_aa)
replace sn_tw_ab=surve`j'_a*survne`j'_b if `j'==adur  // store S_y(tw)*S_0(tw) for every individual (given v_ab)
replace sn_tw_ba=surve`j'_b*survne`j'_a if `j'==adur  // store S_y(tw)*S_0(tw) for every individual (given v_ba)
replace sn_tw_bb=surve`j'_b*survne`j'_b if `j'==adur  // store S_y(tw)*S_0(tw) for every individual (given v_bb)


drop lnsurve_a lnsurve_b  lnsurvne_a lnsurvne_b hazn_a hazn_b  surve`j'_a surve`j'_b survne`j'_a survne`j'_b 
compress
}
}

** generate uo.het. probability weights conditional on being warned (treated): Prob(v_aa|T>tw), Prob(v_ab|T>tw)  etc.
replace pn_tw_aa= (sn_tw_aa * p_aa)/(sn_tw_aa*p_aa+sn_tw_ab*p_ab+sn_tw_ba*p_ba+sn_tw_bb*p_bb)   // Bayesian formula to calc Prob(v_aa|T>tw)
replace pn_tw_ab= (sn_tw_ab * p_ab)/(sn_tw_aa*p_aa+sn_tw_ab*p_ab+sn_tw_ba*p_ba+sn_tw_bb*p_bb)   // Bayesian formula to calc Prob(v_ab|T>tw)
replace pn_tw_ba= (sn_tw_ba * p_ba)/(sn_tw_aa*p_aa+sn_tw_ab*p_ab+sn_tw_ba*p_ba+sn_tw_bb*p_bb)   // Bayesian formula to calc Prob(v_ba|T>tw)
replace pn_tw_bb= (sn_tw_bb * p_bb)/(sn_tw_aa*p_aa+sn_tw_ab*p_ab+sn_tw_ba*p_ba+sn_tw_bb*p_bb)   // Bayesian formula to calc Prob(v_bb|T>tw)


** integrate t*f(t): sum up evaluated theta_e(t)*S_e(t)*S_ne(t) from 0 to 720 
g ft_aa=0
g t_ft_aa=0
g ft_ab=0
g t_ft_ab=0
g ft_ba=0
g t_ft_ba=0
g ft_bb=0
g t_ft_bb=0

quietly{
forvalues v=1(1)720{
replace ft_aa=ft_aa+f`v'_aa
replace t_ft_aa=t_ft_aa+`v'*f`v'_aa
replace ft_ab=ft_ab+f`v'_ab
replace t_ft_ab=t_ft_ab+`v'*f`v'_ab
replace ft_ba=ft_ba+f`v'_ba
replace t_ft_ba=t_ft_ba+`v'*f`v'_ba
replace ft_bb=ft_bb+f`v'_bb
replace t_ft_bb=t_ft_bb+`v'*f`v'_bb
}
}
** calculate formula (15) based on f0 distribution:
g Etft=pn_tw_aa*(t_ft_aa/ft_aa)+pn_tw_ab*(t_ft_ab/ft_ab)+pn_tw_ba*(t_ft_ba/ft_ba)+pn_tw_bb*(t_ft_bb/ft_bb)


** sum over individuals and average (i.e. E_x(Y|x)=E(Y))
sum Etft if warn==1 & y024==1	// expected unemployment duration (of the treated) for the non-treated counterfactual

rename Etft Etft_0NT
drop sn_tw_aa- t_ft_bb



*** T4) Calculate E(T_0^1|D=1) (i.e. the treatment counterfactual (for the treated))

** Simulate t*f(t) at ue duration values 1 to 720 (1 day steps, like in estimation) for each individual (i.e. E_v(theta_e(t|v)S_e(t|v)S_ne(t|v)) for y=1,...,720)

g snt_tw_aa=.
g snt_tw_ab=.
g snt_tw_ba=.
g snt_tw_bb=.
g pnt_tw_aa=.
g pnt_tw_ab=.
g pnt_tw_ba=.
g pnt_tw_bb=.

quietly{
forvalues j=1(1)720 {
scalar nse0=max(min(40,`j'), 0)
scalar nse1=max(min(170,(`j'-40)) ,0)
scalar nse2=max(min(150,(`j'-210)), 0) 
scalar nse3=max((`j'-360),0) 
scalar nsn0=max(min(90,`j'), 0)
scalar nsn1=max(min(180,(`j'-90)) ,0)
scalar nsn2=max(min(210,(`j'-270)), 0) 
scalar nsn3=max((`j'-480),0)

scalar dtt1=cond((`j'>90 & `j'<=270),1,0)
scalar dtt2=cond((`j'>270 & `j'<=480),1,0)
scalar dtt3=cond(`j'>480,1,0)
*disp `j'
*disp dtt1
*disp dtt2
*disp dtt3

g ttea0=max(min((`j'-adur),(40-adur)), 0)
g ttea1=max(min(170,(`j'-adur),(`j'-40),(210-adur)), 0) 
g ttea2=max(min(150,(`j'-adur),(`j'-210),(360-adur)), 0)
g ttea3=max(min((`j'-360),(`j'-adur)), 0)
g tteae0=max(min((`j'-aedurS2),(40-aedurS2)), 0)
g tteae1=max(min(170,(`j'-aedurS2),(`j'-40),(210-aedurS2)), 0)
g tteae2=max(min(150,(`j'-aedurS2),(`j'-210),(360-aedurS2)), 0)
g tteae3=max(min((`j'-360),(`j'-aedurS2)), 0)
*list ttea0- tteae3

g ttna0=max(min((`j'-adur),(90-adur)), 0)
g ttna1=max(min(180,(`j'-adur),(`j'-90),(270-adur)), 0) 
g ttna2=max(min(210,(`j'-adur),(`j'-270),(480-adur)), 0)
g ttna3=max(min((`j'-480),(`j'-adur)), 0)
g ttnae0=max(min((`j'-aedurS2),(90-aedurS2)), 0)
g ttnae1=max(min(180,(`j'-aedurS2),(`j'-90),(270-aedurS2)), 0)
g ttnae2=max(min(210,(`j'-aedurS2),(`j'-270),(480-aedurS2)), 0)
g ttnae3=max(min((`j'-480),(`j'-aedurS2)), 0)

#delimit ;
g lnsurve_a=exp(xbe)*exp(LEA)*((nse0 + nse1*exp(LE1) + nse2*exp(LE2) + nse3*exp(LE3))
		+ (exp(DY1)-1)*(ttea0 + ttea1*exp(LE1) + ttea2*exp(LE2) + ttea3*exp(LE3))
		+ (exp(DY1+DY2)-exp(DY1))*(tteae0 + tteae1*exp(LE1) + tteae2*exp(LE2) + tteae3*exp(LE3))); 
g lnsurve_b=exp(xbe)*exp(LEB)*((nse0 + nse1*exp(LE1) + nse2*exp(LE2) + nse3*exp(LE3))
		+ (exp(DY1)-1)*(ttea0 + ttea1*exp(LE1) + ttea2*exp(LE2) + ttea3*exp(LE3))
		+ (exp(DY1+DY2)-exp(DY1))*(tteae0 + tteae1*exp(LE1) + tteae2*exp(LE2) + tteae3*exp(LE3)));
#delimit cr
g surve`j'_a=exp((-1)*lnsurve_a)
g surve`j'_b=exp((-1)*lnsurve_b)

#delimit ;
g lnsurvne_a=exp(xbne)*exp(LNEA)*((nsn0 + nsn1*exp(LNE1) + nsn2*exp(LNE2) + nsn3*exp(LNE3))
		+ (exp(DNY1)-1)*(ttna0 + ttna1*exp(LNE1) + ttna2*exp(LNE2) + ttna3*exp(LNE3))
		+ (exp(DNY1+DNY2)-exp(DNY1))*(ttnae0 + ttnae1*exp(LNE1) + ttnae2*exp(LNE2) + ttnae3*exp(LNE3)));
g lnsurvne_b=exp(xbne)*exp(LNEB)*((nsn0 + nsn1*exp(LNE1) + nsn2*exp(LNE2) + nsn3*exp(LNE3))
		+ (exp(DNY1)-1)*(ttna0 + ttna1*exp(LNE1) + ttna2*exp(LNE2) + ttna3*exp(LNE3))
		+ (exp(DNY1+DNY2)-exp(DNY1))*(ttnae0 + ttnae1*exp(LNE1) + ttnae2*exp(LNE2) + ttnae3*exp(LNE3)));
#delimit cr
g survne`j'_a=exp((-1)*lnsurvne_a)
g survne`j'_b=exp((-1)*lnsurvne_b)

g war_t=(warn==1 & `j'>adur)   //** only correct for warned people
g enf_t=(warn==1 & `j'>aedurS2)  //** works for warn=1 people; simulated enf'dur used, aedurS2

g hazn_a=exp(xbne + LNEA + dtt1*LNE1 + dtt2*LNE2 + dtt3*LNE3 + war_t*DNY1 + enf_t*DNY2)
g hazn_b=exp(xbne + LNEB + dtt1*LNE1 + dtt2*LNE2 + dtt3*LNE3 + war_t*DNY1 + enf_t*DNY2)

g f`j'_aa=hazn_a*surve`j'_a*survne`j'_a
g f`j'_ab=hazn_b*surve`j'_a*survne`j'_b
g f`j'_ba=hazn_a*surve`j'_b*survne`j'_a
g f`j'_bb=hazn_b*surve`j'_b*survne`j'_b

replace f`j'_aa=0 if `j'<adur
replace f`j'_ab=0 if `j'<adur
replace f`j'_ba=0 if `j'<adur
replace f`j'_bb=0 if `j'<adur



** generate Prob(Ty>tw,T0>tw)=S_y(tw)*S_0(tw) for cond. uo.het. probability weights (see p.23)
replace snt_tw_aa=surve`j'_a*survne`j'_a if `j'==adur  // store S_y(tw)*S_0(tw) for every individual (given v_aa)
replace snt_tw_ab=surve`j'_a*survne`j'_b if `j'==adur  // store S_y(tw)*S_0(tw) for every individual (given v_ab)
replace snt_tw_ba=surve`j'_b*survne`j'_a if `j'==adur  // store S_y(tw)*S_0(tw) for every individual (given v_ba)
replace snt_tw_bb=surve`j'_b*survne`j'_b if `j'==adur  // store S_y(tw)*S_0(tw) for every individual (given v_bb)


drop ttea0- tteae3 ttna0- ttnae3 lnsurve_a lnsurve_b  lnsurvne_a lnsurvne_b hazn_a hazn_b  surve`j'_a surve`j'_b survne`j'_a survne`j'_b war_t enf_t
compress
}
}

** generate uo.het. probability weights conditional on being warned (treated): Prob(v_aa|T>tw), Prob(v_ab|T>tw)  etc.
replace pnt_tw_aa= (snt_tw_aa * p_aa)/(snt_tw_aa*p_aa+snt_tw_ab*p_ab+snt_tw_ba*p_ba+snt_tw_bb*p_bb)   // Bayesian formula to calc Prob(v_aa|T>tw)
replace pnt_tw_ab= (snt_tw_ab * p_ab)/(snt_tw_aa*p_aa+snt_tw_ab*p_ab+snt_tw_ba*p_ba+snt_tw_bb*p_bb)   // Bayesian formula to calc Prob(v_ab|T>tw)
replace pnt_tw_ba= (snt_tw_ba * p_ba)/(snt_tw_aa*p_aa+snt_tw_ab*p_ab+snt_tw_ba*p_ba+snt_tw_bb*p_bb)   // Bayesian formula to calc Prob(v_ba|T>tw)
replace pnt_tw_bb= (snt_tw_bb * p_bb)/(snt_tw_aa*p_aa+snt_tw_ab*p_ab+snt_tw_ba*p_ba+snt_tw_bb*p_bb)   // Bayesian formula to calc Prob(v_bb|T>tw)


** integrate t*f(t): sum up evaluated theta_e(t)*S_e(t)*S_ne(t) from 0 to 720 
g ft_aa=0
g t_ft_aa=0
g ft_ab=0
g t_ft_ab=0
g ft_ba=0
g t_ft_ba=0
g ft_bb=0
g t_ft_bb=0

quietly{
forvalues v=1(1)720{
replace ft_aa=ft_aa+f`v'_aa
replace t_ft_aa=t_ft_aa+`v'*f`v'_aa
replace ft_ab=ft_ab+f`v'_ab
replace t_ft_ab=t_ft_ab+`v'*f`v'_ab
replace ft_ba=ft_ba+f`v'_ba
replace t_ft_ba=t_ft_ba+`v'*f`v'_ba
replace ft_bb=ft_bb+f`v'_bb
replace t_ft_bb=t_ft_bb+`v'*f`v'_bb
}
}
** calculate formula (14) based on f0 distribution:
g Etft=pnt_tw_aa*(t_ft_aa/ft_aa)+pnt_tw_ab*(t_ft_ab/ft_ab)+pnt_tw_ba*(t_ft_ba/ft_ba)+pnt_tw_bb*(t_ft_bb/ft_bb)


** sum over individuals and average (i.e. E_x(Y|x)=E(Y))
sum Etft if warn==1 & y024==1	// expected unemployment duration (of the treated) for the treated counterfactual

rename Etft Etft_0T
drop snt_tw_aa- t_ft_bb


** Treatment Effect: Difference of means (in days of unemployment)
sum Etft_0T Etft_0NT if warn==1 & y024==1



save sim_values_TE.dta
