clear all

% folders
folder_res = './fc/Bquee/'; %cc%
folder_tex = './';
name_experiment = folder_res((end - 6 + 1):(end - 1));

% sample size(s)
v_N = [5];
v_N = [100]; %cc%
v_T = [25; 50; 100; 200];
n_N = length(v_N);
n_T = length(v_T);

% select column to analyse
parameter = 1; %cc% scalar integer: =1 (psis), =2 (alphas), =3 (betas), =4 (sgmqsqs)
if     parameter == 1 parameter_name = 'psi'
elseif parameter == 2 parameter_name = 'alpha'
elseif parameter == 3 parameter_name = 'beta'
end

for i_N = 1:n_N
     N = v_N(i_N);

     m_bias = zeros(N, n_T);
     m_rmse = zeros(N, n_T);
     m_size = zeros(N, n_T);
     m_powe = zeros(N, n_T);
     for i_T = 1:n_T
          T = v_T(i_T);

          % load simulation results
          load(sprintf('%sN%03d-T%04d', folder_res, N, T))

          % focus only on non-Gaussian errors %cc%
          gaussian = l_xtra.gaussian;
          if gaussian ~= 0
               error('In the paper we report only results for non-Gaussian errors')
          end

          m_parameter_t = squeeze(l_t.o_a_theta(:, parameter, :)); % (N,R)
          m_parameter_e = squeeze(l_e.o_a_eml  (:, parameter, :)); % (N,R)
          m_parameter_v = squeeze(l_s.o_a_sml  (:, parameter, :)); % (N,R) sandwich

          %% bias and RMSE
          m_parameter_exc = m_parameter_e - m_parameter_t; % (N,R)
          m_parameter_exc_sq = m_parameter_exc .* m_parameter_exc;
          v_bias = mean(m_parameter_exc, 2); % N x 1
          v_rmse = sqrt(mean(m_parameter_exc_sq, 2));

          m_bias(:, i_T) = v_bias;
          m_rmse(:, i_T) = v_rmse;

          %% size and power
          v_delta = zeros(N, 1); % if you want to compute power, add something different from zero (e.g., -0.1)
          [v_size ~] = fn_power_function(m_parameter_t, m_parameter_e, m_parameter_v, v_delta); 
          m_size(:, i_T) = v_size;

          v_delta = 0.2 * ones(N, 1); %cc%
          [v_powe ~] = fn_power_function(m_parameter_t, m_parameter_e, m_parameter_v, v_delta); 
          m_powe(:, i_T) = v_powe;
     end

     %% sort tables wrt the true psi (from the smallest to the largest)
     v_tpsi = l_t.o_a_theta(:, 1, 1); % (N,1)
     v_parameter_t = m_parameter_t(:, 1); % (N,1)
     
     % sort psi
     [v_tpsi_sorted, v_ind] = sort(v_tpsi);

     % sort tables wrt to psi (to kill sorting just set 'v_ind=1:N')
     v_parameter_t_sorted = v_parameter_t(v_ind);
     m_bias_sorted        = m_bias       (v_ind, :);
     m_rmse_sorted        = m_rmse       (v_ind, :);
     m_size_sorted        = m_size       (v_ind, :);
     m_powe_sorted        = m_powe       (v_ind, :);

     %% specification of the "dotted part" in the table
     if N == 100 %cc%
          v_selected_i = [[1:3] [51 52 53] [98 99 100]]'; %cc%
          v_dots_unit = [4 97]'; %cc%
     elseif N == 5
          v_selected_i = [1:N]';
          v_dots_unit = 0; % any number < 1 works here
     else
          error('This part of the code is written either for N=5 or N=100')
     end

     %% print bias and RMSE
     filename_tex = sprintf('in_tb_bias_rmse_%s_gaussian%d_%s_N%03d.tex', name_experiment, gaussian, parameter_name, N);
     zz = fopen([folder_tex filename_tex], 'w+');

     for i_row = 1:N
          if any(i_row == v_selected_i)
               parameter_true = v_parameter_t_sorted(i_row);

               % print true value (e.g., '\psi{i0}=0.1234')
               fprintf(zz, '$\\%s_{%3d,0}=%6.4f$', parameter_name, i_row, parameter_true);
               for i_col = 1:n_T
                    bias = m_bias_sorted(i_row, i_col);
                    rmse = m_rmse_sorted(i_row, i_col);
                    fprintf(zz, ' & % 7.4f & %6.4f', bias, rmse);

                    % put an extra column
                    if i_col == 2 %cc%
                         fprintf(zz, ' &');
                    end
                    
                    % end of line
                    if i_col == n_T
                         fprintf(zz, ' %s\n', '\\');
                    end
               end
          elseif any(i_row == v_dots_unit)
               fprintf(zz, '%s', '\multicolumn{1}{c|}{\vdots}');

               s_qwe = '\mc{\vdots}';
               fprintf(zz, ' & %s & %s & %s & %s', s_qwe, s_qwe, s_qwe, s_qwe); fprintf(zz, ' &'); % extra column
               fprintf(zz, ' & %s & %s & %s & %s', s_qwe, s_qwe, s_qwe, s_qwe);
               fprintf(zz, ' %s\n', '\\');
          end
     end
     fclose(zz);

     %% print size and power
     filename_tex = sprintf('in_tb_size_powe_%s_gaussian%d_%s_N%03d.tex', name_experiment, gaussian, parameter_name, N);
     zz = fopen([folder_tex filename_tex], 'w+');

     for i_row = 1:N
          if any(i_row == v_selected_i)
               parameter_true = v_parameter_t_sorted(i_row);

               % print true value (e.g., '\psi{i0}=0.1234')
               fprintf(zz, '$\\%s_{%3d,0}=%6.4f$', parameter_name, i_row, parameter_true);

               % size
               for i_col = 1:n_T
                    fprintf(zz, ' & %6.4f', m_size_sorted(i_row, i_col));
               end
               % put an extra column
               fprintf(zz, ' &');
               
               % power
               for i_col = 1:n_T
                    fprintf(zz, ' & %6.4f', m_powe_sorted(i_row, i_col));
               end
               % end of line
               fprintf(zz, ' %s\n', '\\');

          elseif any(i_row == v_dots_unit)
               fprintf(zz, '%s', '\multicolumn{1}{c|}{\vdots}');

               s_qwe = '\mc{\vdots}';
               fprintf(zz, ' & %s & %s & %s & %s', s_qwe, s_qwe, s_qwe, s_qwe); fprintf(zz, ' &'); % extra column
               fprintf(zz, ' & %s & %s & %s & %s', s_qwe, s_qwe, s_qwe, s_qwe);
               fprintf(zz, ' %s\n', '\\');
          end
     end
     fclose(zz);
end
