clear all

folder = './rc/Bquee/';
texfolder = './';

direc = dir(sprintf('%sN*.mat', folder));
n_col = size(direc, 1);
v_file = {};
[v_file{1:n_col, 1}] = deal(direc.name);
disp(v_file)

for i_col = 1:n_col
     filenam = v_file{i_col, 1};
     fullname = sprintf('%s%s', folder, filenam);
     load(fullname, 'l_t', 'l_e', 'l_xtra')
     
     %a_tru = l_t.o_a_theta; % N x P x R
     v_tru = l_t.o_m_theta(:, 1); % (P,1)
     a_est = l_e.o_a_eml; 
     [N P R] = size(a_est);
     a_tru = repmat(v_tru', [N 1 R]);

     if exist('m_tb_true') ~= 1
          m_tb_true = zeros(P, n_col);
          m_tb_bias = zeros(P, n_col);
          m_tb_rmse = zeros(P, n_col);
          m_tb_size = zeros(P, n_col);
     end

     % calculate bias, rmse, size of mean group (mg) estimator
     a_mg_est = mean(a_est, 1);  % 1 x P x R
     m_mg_est = squeeze(a_mg_est); % P x R
     m_mg_tru = squeeze(mean(a_tru, 1)); % P x R (1 x P x R before squeezing) THERE IS A REASON FOR THIS INEFFICIENT CODING
     m_mg_est_exc = m_mg_est - m_mg_tru; % (P,R)
     v_bias = mean(m_mg_est_exc, 2); % (P,1)
     v_rmse = realsqrt(mean(m_mg_est_exc.^2, 2)); % (P,1)
     
     % if 1: compute estimate of variance of the MG estimator using vectorized code (computationally efficient); 
     % if 0: use loops (not efficient); 
     if 0
          a_mg_est_bis = repmat(a_mg_est, [N 1 1]); % N x P x R
          a_est_exc = a_est - a_mg_est_bis;
          a_est_exc_sq = a_est_exc.^2;
          m_mg_var = squeeze(sum(a_est_exc_sq, 1) ./ (N * (N - 1))); % P x R (1 x P x R before squeezing)
          m_mg_se = sqrt(m_mg_var);
          m_mg_tval_size = m_mg_est_exc ./ m_mg_se;
          cval = 1.96;
          m_cval = cval .* ones(size(m_mg_tval_size));
          m_mg_size = abs(m_mg_tval_size) > m_cval;
     else
          m_mg_size = zeros(P, R);
          v_cval = 1.96 .* ones(P, 1);
          for r = 1:R
               m_tru = a_tru(:, :, r); % N x P
               m_est = a_est(:, :, r);
               v_mg_est = mean(m_est, 1)'; % P x 1
               v_mg_tru = mean(m_tru, 1)';
               m_sum = zeros(P);
               for ii = 1:N
                    v_est = m_est(ii, :)'; % (P,1)
                    v_est_exc = v_est - v_mg_est; % (P,1)
                    m_sum = m_sum + (v_est_exc * v_est_exc'); % P x P
               end
               v_mg_var = diag(m_sum) ./ (N * (N - 1)); % (P,1)
               v_mg_se = realsqrt(v_mg_var); % (P,1)
               v_mg_tval = (v_mg_est - v_mg_tru) ./ v_mg_se; % (P,1)
               v_mg_size = abs(v_mg_tval) > v_cval; % (P,1)
               m_mg_size(:, r) = v_mg_size; % (P,1)
          end
     end
     v_size = mean(m_mg_size, 2); % P x 1

     m_tb_true(:, i_col) = m_mg_tru(:, 1);
     m_tb_bias(:, i_col) = v_bias;
     m_tb_rmse(:, i_col) = v_rmse; 
     m_tb_size(:, i_col) = v_size;

end 

%% print results to a tex-file
list{1} = m_tb_bias;
list{2} = m_tb_rmse;
list{3} = m_tb_size;
for k = 1:length(list)
     v_texfilenam = ['bias_mg_estimator'; ...
                     'rmse_mg_estimator'; ...
                     'size_mg_estimator'];
     texfilenam = sprintf('in_tb_%s_gaussian%d_%s.tex' ...
     , folder((end - 6 + 1):(end - 1)) ...
     , l_xtra.gaussian ...
     , v_texfilenam(k, :));
     zz = fopen([texfolder texfilenam], 'w+t');
     mat_temp = list{k}; % P x n_col, where P is the number of parameters (4: psi, alpha, beta, sgmsq) and n_col the number of datasets
     mat_temp([2 end], :) = []; %cc% remove alpha and sigmasq
     mat = mat_temp; % (2, n_col)
     for i_row = 1:size(mat, 1)
          if i_row == 1
               fprintf(zz, '$\\hat{\\bar{\\psi}}_{\\mathit{MG}}$  & ');
          elseif i_row == 2
               fprintf(zz, '$\\hat{\\bar{\\beta}}_{\\mathit{MG}}$ & ');
          end
          for i_col = 1:size(mat, 2)
               if i_col < size(mat, 2)
                    if i_col ~= 4 & i_col ~= 8 & i_col ~= 12 %cc%
                         fprintf(zz, '%8.4f & ', mat(i_row, i_col));
                    else
                         fprintf(zz, '%8.4f & & ', mat(i_row, i_col));
                    end
               else
                    fprintf(zz, '%8.4f %s\n', mat(i_row, i_col), '\\');
               end
          end
     end
     fclose(zz);
end
