clear all

folder = './fc/Bquee/'; %cc%
parameter = 1; %cc% 1 for psi's, 2 for alpha's, 3 for beta's
texfolder = './';
v_N = [25; 50; 75; 100];
v_T = [25; 50; 100; 200];
n_N = length(v_N);
n_T = length(v_T);

if parameter == 1
     v_unit = [6; 2; 7];
elseif parameter == 3
     v_unit = [14; 16; 4];
end
n_unit = length(v_unit);

for i_unit = 1:n_unit
     close all
     %% Build figure.
     figure(1)
     h = figure(1);
     for i_N = 1:n_N
          N = v_N(i_N);
          for i_T = 1:n_T
               T = v_T(i_T);
               
               % load simulation results
               load(sprintf('%sN%03d-T%04d.mat', folder, N, T))

               % 1st column psi's, 2nd alpha's, 3rd beta's
               m_tpsi = squeeze(l_t.o_a_theta(:, parameter, :)); % N x R
               m_epsi = squeeze(l_e.o_a_eml  (:, parameter, :));
               %m_vpsi = squeeze(l_v.o_a_vml  (:, parameter, :));
               m_vpsi = squeeze(l_s.o_a_sml  (:, parameter, :)); %cc% sandwich

               m_tpsi = m_tpsi(v_unit(i_unit), :); % 1 x R
               m_epsi = m_epsi(v_unit(i_unit), :);
               m_vpsi = m_vpsi(v_unit(i_unit), :);

               tpsi = m_tpsi(1);
               if parameter == 1
                    delta_min = -1 - tpsi;
                    delta_max =  1 - tpsi;
                    m_delta = [delta_min:0.01:delta_max];
               elseif parameter == 3
                    m_delta = [-1:0.01:1];
               end
               [m_powe m_null] = fn_power_function(m_tpsi, m_epsi, m_vpsi, m_delta);  
               % CAREFUL!!: m_powe and m_null are 1 x n_delta vectors
               if i_T == 1
                    %subplot(2, 2, i_N)
                    if i_N == 1
                         subplot(2, 2, 1)
                    elseif i_N == 2
                         subplot(2, 2, 3)
                    elseif i_N == 3
                         subplot(2, 2, 2)
                    elseif i_N == 4
                         subplot(2, 2, 4)
                    end
                    v_rgb = [57 106 177] / 255; % blue
                    line1 = plot(m_null, m_powe, ...
                         ':', ...
                         'Color', v_rgb, ...
                         'LineWidth', 1.5);
                         %'LineSpec', ':', ...
                    if parameter == 3
                         xmin = min(m_null(:)) - 0.1;
                         xmax = max(m_null(:));
                         xlim([xmin, xmax])
                         ylim([0, 1])
                    end
                    %box off
                    hold on
                    % line with true psi
                    line([tpsi tpsi], [0, 1], ...
                         'LineStyle', '--', ... 
                         'Color', [0 0 0] + .5) % grey
               elseif i_T == 2
                    v_rgb = [83 81 84] / 255; % grey
                    line2 = plot(m_null, m_powe, ...
                         '-.', ...
                         'Color', v_rgb);
               elseif i_T == 3
                    v_rgb = [204 37  41] / 255; % red
                    line3 = plot(m_null, m_powe, ...
                         '--', ...
                         'Color', v_rgb);
               elseif i_T == 4
                    v_rgb = [0 0 0] / 255; % black
                    line4 = plot(m_null, m_powe, ...
                         '-', ...
                         'Color', v_rgb);
                    title(sprintf('$N = %3d$', v_N(i_N)), 'interpreter', 'latex');
                    if any(i_N == [2 4]) % put some extra space at the bottom of N=50 and N=100
                         xlabel(sprintf(' '));
                    end
                    hold off
               end
          end
          %if parameter == 1
               legend([line1, line2, line3, line4], ...
                    {'$T = 25$', '$T = 50$', '$T = 100$', '$T = 200$'}, ...
                    'Interpreter', 'latex', ...
                    'Location','southwest', 'FontSize', 5);
               legend('boxoff')
          %end
     end
     if parameter == 1
          eps_figfilenam = sprintf('fg_power_function_%s_psi_unit%03d.eps', folder((end - 6 + 1):(end - 1)), v_unit(i_unit));
     elseif parameter == 3
          eps_figfilenam = sprintf('fg_power_function_%s_bet_unit%03d.eps', folder((end - 6 + 1):(end - 1)), v_unit(i_unit));
     end
     saveas(h, [texfolder eps_figfilenam], ...
          'epsc'); % this option saves eps with colors
     close(h)
end
