clear all

folder_res = './fc/Bquee/'; %cc%
folder_tex = './';
name_experiment = folder_res((end - 6 + 1):(end - 1));
v_N = [25; 50; 75; 100];
v_T = [25; 50; 100; 200];
n_N = length(v_N);
n_T = length(v_T);

% select column to analyse
parameter = 3; %cc% scalar integer: =1 (psis), =2 (alphas), =3 (betas), =4 (sgmqsqs)
if     parameter == 1 parameter_name = 'psi'
elseif parameter == 2 parameter_name = 'alpha'
elseif parameter == 3 parameter_name = 'beta'
end

close all
%% Build figure.
h = figure;
for i_N = 1:n_N
     N = v_N(i_N);
     m_size_1 = zeros(N, n_T);
     m_size_2 = zeros(N, n_T);

     v_delta = zeros(N, 1); % if you want to compute power, add something different from zero (e.g., -0.1)
     for i_T = 1:n_T
          T = v_T(i_T);

          % load simulation results
          load(sprintf('%sN%03d-T%04d', folder_res, N, T))

          % focus only on non-Gaussian errors %cc%
          gaussian = l_xtra.gaussian;
          if gaussian ~= 0
               error('In the paper we report only results for non-Gaussian errors')
          end

          m_t   = squeeze(l_t.o_a_theta(:, parameter, :)); % 1st column, psi's, 2nd alpha's, 3rd beta's
          m_e   = squeeze(l_e.o_a_eml  (:, parameter, :)); % N x R
          m_v_1 = squeeze(l_v.o_a_vml  (:, parameter, :)); % standard
          m_v_2 = squeeze(l_s.o_a_sml  (:, parameter, :)); % sandwich

          v_t = m_t(:, 1); % N x 1
          [v_size_1 ~] = fn_power_function(m_t, m_e, m_v_1, v_delta); m_size_1(:, i_T) = v_size_1;
          [v_size_2 ~] = fn_power_function(m_t, m_e, m_v_2, v_delta); m_size_2(:, i_T) = v_size_2;
     end
     % box-plots
     % 2 x 2 subplot
     subplot(2, 2, i_N)
     mat = m_size_2; %cc% N x n_T (i.e.: [sandwich])
     boxplot(m_size_2 ... %cc%
     , 'Labels',  v_T ...
     , 'Colors', 'k' ...
     , 'Symbol', '.' ...
     )
     %ylim([0 0.12]) %cc%
     %set(gca,'YTick', 0.02:0.02:0.1)

     % add horizontal "-.-" line at 0.05
     xlim = get(gca, 'xlim'); % GET gets object properties. GCA: get handle to current axis.
     hold on
     plot(xlim, [0.05 0.05], 'Color', 'k', 'LineStyle', '-.')
     hold off
     title(sprintf('$N = %3d$', N), 'interpreter', 'latex');
     xlabel('$T$', 'interpreter', 'latex');
     ylabel('Size');

end
filename_eps = sprintf('fg_boxplot_size_%s_gaussian%d_%s.eps', name_experiment, gaussian, parameter_name);
saveas(h, [folder_tex filename_eps], ...
     'eps');
close(h)
