clear all

folder = './fc/Bquee/'; %cc%
parameter = 3; %cc% 1 for psi's, 2 for alpha's, 3 for beta's
texfolder = './';
v_N = [25; 50; 75; 100];
v_T = [25; 50; 100; 200];
n_N = length(v_N);
n_T = length(v_T);

close all
%% Build figure.
h = figure;
for i_N = 1:n_N
     N = v_N(i_N);

     m_aver = zeros(N, n_T);
     m_bias = zeros(N, n_T);
     m_rmse = zeros(N, n_T);
     for i_T = 1:n_T
          T = v_T(i_T);

          % load simulation results
          load(sprintf('%sN%03d-T%04d.mat', folder, N, T))

          m_tpsi = squeeze(l_t.o_a_theta(:, parameter, :)); % 1st column, psis
          m_epsi = squeeze(l_e.o_a_eml  (:, parameter, :)); % N x R
          m_est_exc = m_epsi - m_tpsi; % N x R
          m_est_exc_sq = m_est_exc .* m_est_exc;
          v_rmse = sqrt(mean(m_est_exc_sq, 2));
          m_rmse(:, i_T) = v_rmse;
     end
     %v_tpsi = m_tpsi(:, 1);

     % box-plots
     % 2 x 2 subplot
     subplot(2, 2, i_N)
     boxplot(m_rmse ...
     , 'Labels',  v_T ...
     , 'Colors', 'k' ...
     , 'Symbol', '.' ...
     )
     title(sprintf('$N = %3d$', v_N(i_N)), 'interpreter', 'latex');
     xlabel('$T$', 'interpreter', 'latex');
     ylabel('RMSE');
end
if parameter == 1
     eps_figfilenam = sprintf('fg_boxplot_%s_rmse_psix.eps', folder((end - 6 + 1):(end - 1)));
elseif parameter == 3
     eps_figfilenam = sprintf('fg_boxplot_%s_rmse_beta.eps', folder((end - 6 + 1):(end - 1)));
end
saveas(h, [texfolder eps_figfilenam], ...
     'eps');
close(h)
