clear all
disp('*************************************')
format short
warning off

% set seed
rand('twister', 5489); % setting the uniform seed
randn('state', 0);     % setting the normal seed
folder = './rc/B'; %cc%

N = 25; %cc%
nud = 2; %cc% number of upper off-diagonals; 1: rook formation; 2: queen; 5: distance.
gaussian = 0; %cc

n_repl = 1000;
v_T = 25 .* [1 2 4 8]';
no_dum = 2;

m_C = zeros(N);
for i_ud = 1:min(nud, N - 1) % mnemonic: i_ud "ith upper diagonal"
     v_iota = ones(N - i_ud, 1);
     m_C = m_C + diag(v_iota, -i_ud) + diag(v_iota, i_ud);
end

% row normalize
v_rowsum_C = sum(m_C, 2);
m_rowsum_C = repmat(v_rowsum_C, [1 N]);
m_W = m_C ./ m_rowsum_C;

l_true.gaussian = gaussian;

v_theta = [0.4 1 0.5 1]'; %cc% psi, alpha, beta, sgmsq
l_true.v_theta = v_theta;
l_true.N = N;
l_true.P = length(v_theta);
disp(v_theta');

if nud == 1; folder = sprintf('%srook/', folder); end
if nud == 2; folder = sprintf('%squee/', folder); end
if nud == 5; folder = sprintf('%sdist/', folder); end
for i_T = 1:size(v_T, 1)
     T = v_T(i_T, 1);

     t0 = cputime;
     filesav = sprintf('%sN%03d-T%04d.mat', folder, N, T);

     for dum = 1:no_dum
          tic;
          disp(filesav)
          fn_runsave_rc(l_true, m_W, T, n_repl, filesav, t0)
          disp(['Enlapsed time: ' num2str(toc)]);
          tic;
     end
end
