clear all
disp('*************************************')
format short
warning off

% set seed
rand('twister', 5489); % setting the uniform seed
randn('state', 0);     % setting the normal seed
folder = './fc/'; %cc%

N = 50; %cc% or N = 100 to replicate results in Table 1.
nud = 2; %cc% number of upper off-diagonals; 1: rook formation; 2: queen; 5: distance.
gaussian = 0; %cc% gaussian or non-gaussian-errors

n_repl = 1000;
v_T = 25 .* [1 2 4 8]';
no_dum = 2;

% generating parameters
v_stand_norm = randn(10 * N, 1); % Columns 1 and 2 chisquared-sigmasq, 3 alpha, 4-10 (not used)
v_stand_unif = rand(3 * N, 1); % Column 1 beta, 2 psi, 3 (not used)
m_stand_norm = reshape(v_stand_norm, 10, N)'; % N x 4
m_stand_unif = reshape(v_stand_unif, 3, N)'; % N x 3

m_stand_normsq = m_stand_norm(:, 1:2).^2; % N x 2
v_chisq_2df = sum(m_stand_normsq, 2);
v_sgmsq = (v_chisq_2df ./ 4) + 0.5;
v_sgm = sqrt(v_sgmsq);

v_alpha = 1 + m_stand_norm(:, 3); % alpha_i ~ N(1, 1)
%v_beta = zeros(N, 1); %cc%
v_beta = m_stand_unif(:, 1); % beta_i ~ U(0, 1)
v_psi =  0.8 .* m_stand_unif(:, 2);  % psi_i ~ U(0, 0.8)

if sum(v_beta == 0) == N % Experiment A
     m_theta = [v_psi v_alpha v_sgmsq];
     folder = sprintf('%sA', folder);
else % Experiment B
     m_theta = [v_psi v_alpha v_beta v_sgmsq];
     folder = sprintf('%sB', folder);
end
disp(m_theta);

m_C = zeros(N);
for i_ud = 1:min(nud, N - 1) % mnemonic: i_ud "ith upper diagonal"
     v_iota = ones(N - i_ud, 1);
     m_C = m_C + diag(v_iota, -i_ud) + diag(v_iota, i_ud);
end

% row normalize
v_rowsum_C = sum(m_C, 2);
m_rowsum_C = repmat(v_rowsum_C, [1 N]);
m_W = m_C ./ m_rowsum_C;

m_Lambda_sgm = diag(v_sgm);
m_B = diag(v_beta);
m_Psi = diag(v_psi);
invA = inv(eye(N) - (m_Psi * m_W));

v_mu = invA * v_alpha;
m_Phi = invA * m_B;
m_R = invA * m_Lambda_sgm;

l_true.v_mu = v_mu;
l_true.m_Phi = m_Phi;
l_true.m_R = m_R;
l_true.gaussian = gaussian;

if nud == 1; folder = sprintf('%srook/', folder); end
if nud == 2; folder = sprintf('%squee/', folder); end
if nud == 5; folder = sprintf('%sdist/', folder); end
for i_T = 1:size(v_T, 1)
     T = v_T(i_T, 1);

     t0 = cputime;
     filesav = sprintf('%sN%03d-T%04d.mat', folder, N, T);

     for dum = 1:no_dum
          tic;
          disp(filesav)
          fn_runsave(m_theta, l_true, m_W, T, n_repl, filesav, t0)
          disp(['Enlapsed time: ' num2str(toc)]);
          tic;
     end
end
