function fn_runsave_rc(l_true, m_W, T, n_repl, filesav, t0)
N = l_true.N;
P = l_true.P;
gaussian = l_true.gaussian;

v_theta = l_true.v_theta;
m_theta_store = repmat(v_theta, [1 n_repl]); % P x R
% NOTE sigmasq (which is v_theta(end)) is not used anywhere

% initialize variables
a_theta = zeros(N, P, n_repl);
a_eml   = zeros(N, P, n_repl);
a_vml   =  ones(N, P, n_repl);
a_sml   =  ones(N, P, n_repl);

m_Axs = eye(N) - (0.5 .* m_W);
invAxs = inv(m_Axs);
sigmasq_v = N / trace(invAxs * invAxs'); % inefficient
%sigmasq_v = N / sum(sum(invAxs.^2, 2), 1); % efficient
for r = 1:n_repl
     % generate random coefficients
     v_alpha = v_theta(2) + randn(N, 1); % alpha_i ~ N(1, 1)
     v_psi = (2 * v_theta(1)) .* rand(N, 1); % psi_i ~ U(0, 0.8), see note 20170317
     v_beta = (2 * v_theta(3)) .* rand(N, 1); % beta_i ~ U(0, 1)
     m_stand_norm = randn(N, 2); % N x 2
     m_stand_normsq = m_stand_norm.^2;
     v_chisq_2df = sum(m_stand_normsq, 2);
     v_sgmsq = (v_chisq_2df ./ 4) + 0.5;
     v_sgm = sqrt(v_sgmsq);
     m_theta = [v_psi v_alpha v_beta v_sgmsq];

     m_Psi = diag(v_psi);
     m_B = diag(v_beta);
     m_Lambda_sgm = diag(v_sgm);
     invA = inv(eye(N) - (m_Psi * m_W));

     v_mu = invA * v_alpha;
     m_Phi = invA * m_B;
     m_R = invA * m_Lambda_sgm;

     % generation of the regressor x_{it}
     % burn-in period (TO BE REMOVED IN NEXT VERSION OF THE CODE; KEPT FOR CONSISTENCY)
     m_v = randn(N, 100 + T);
     if 0 %cc% 
          m_x = m_v(:, (end - T + 1):end); % TO MAKE THE PREVIOUS RESULTS REPLICABLE
     else
          m_x = invAxs * (sqrt(sigmasq_v) .* m_v(:, (end - T + 1):end)); % N x T
     end

     % distribution of the error
     if gaussian % zeta_{it} ~ IIDN(0,1)
          m_zeta = randn(N, T); %cc%
     else % zeta_{it} ~ [chi^2(2) - 2] / 2
          mat1 = randn(N, T);
          mat2 = randn(N, T);
          m_zeta = (((mat1.^2) + (mat2.^2)) - 2) ./ 2;
     end
     m_y = repmat(v_mu, [1 T]) + (m_Phi * m_x) + (m_R * m_zeta); % N x T
     if P == 3 % intercept only
          a_x = ones(N, T, 1);
     elseif P == 4 % intercept plus predeterminated variables
          a_x = ones(N, T, 2);
          a_x(:, :, 2) = m_x;
     else
          error('Something here is not quite right, please check the code before proceeding')
     end

     % store the true theta
     a_theta(:, :, r) = m_theta;
     
     if 1 %cc%
          l_out = fn_ml_Npsi_NKbeta_Nsgmsq(m_y, a_x, m_W);
          a_eml(:, :, r) = l_out.m_theta;
          a_vml(:, :, r) = l_out.m_variance;
          a_sml(:, :, r) = l_out.m_sandwich;
     else
          % estimated homogeneous model (with heterogeneous intercept)
          info.lflag = 0; % required for exact results
          info.model = 1; % spatial fixed effects (x may not contain an intercept)
          %info.fe = 1; % do not print intercept and fixed effects; use info.fe=1 to turn on

          % wide2long
          v_y_long_format = m_y(:);
          v_x_long_format = m_x(:); %!! THIS LINE WORKS ONLY IF THERE IS ONLY ONE EXOGENOUS VARIABLE; ADJUST THE CODE ACCORDINGLY OTHEWISE
          
          results = sar_panel_FE(v_y_long_format, v_x_long_format, m_W, T, info); 

          m_theta = zeros(N, 4); %cc%
          m_theta(:, 1) = results.rho * ones(N, 1); % psi
          m_theta(:, 2) = results.sfe; % intercept
          m_theta(:, 3) = results.beta(1) * ones(N, 1); % exogeneous variable
          %m_theta(:, 4) = results. * ones(N, 1); % sigmasq

          % store results
          %m_theta
          a_eml(:, :, r) = m_theta;

          %!! TODO: SAVE THE VARIANCE
          %a_vml(:, :, r) = l_out.m_variance;
          %a_sml(:, :, r) = l_out.m_sandwich;
     end
end  

%% save results
% load previously stored data
if exist(filesav, 'file')
     load(filesav)
     o_a_theta = l_t.o_a_theta; % old
     o_m_theta = l_t.o_m_theta;
     o_a_eml   = l_e.o_a_eml; 
     o_a_vml   = l_v.o_a_vml; 
     o_a_sml   = l_s.o_a_sml; 

     disp(['Previous number of iterations: ' int2str(size(o_a_theta, 3))]);
else
     o_a_theta = []; % old
     o_m_theta = [];
     o_a_eml   = [];
     o_a_vml   = [];
     o_a_sml   = [];
end

% update
n_a_theta = cat(3, o_a_theta , a_theta); % new
n_m_theta = cat(2, o_m_theta , m_theta_store); % P x R
n_a_eml   = cat(3, o_a_eml   , a_eml  ); % N x P x R
n_a_vml   = cat(3, o_a_vml   , a_vml  );
n_a_sml   = cat(3, o_a_sml   , a_sml  );

l_t.o_a_theta = n_a_theta;
l_t.o_m_theta = n_m_theta;
l_e.o_a_eml   = n_a_eml  ;
l_v.o_a_vml   = n_a_vml  ;
l_s.o_a_sml   = n_a_sml  ;

l_xtra.gaussian = gaussian;
l_xtra.tottime = cputime - t0;

% (over)write the file
save(filesav, ...
'l_t', ...
'l_e', ...
'l_v', ...
'l_s', ...
'l_xtra')
end
