function fn_runsave(m_theta, l_true, m_W, T, n_repl, filesav, t0)
N = size(m_theta, 1);
v_mu = l_true.v_mu;
m_Phi = l_true.m_Phi;
m_R = l_true.m_R;
gaussian = l_true.gaussian;

P = size(m_theta, 2);
% initialize variables
a_theta = zeros(N, P, n_repl);
a_eml   = zeros(N, P, n_repl);
a_vml   =  ones(N, P, n_repl);
a_sml   =  ones(N, P, n_repl);

m_Axs = eye(N) - (0.5 .* m_W);
invAxs = inv(m_Axs);
sigmasq_v = N / trace(invAxs * invAxs'); % inefficient
%sigmasq_v = N / sum(sum(invAxs.^2, 2), 1); % efficient
for r = 1:n_repl
     % generation of the regressor x_{it}
     % burn-in period (TO BE REMOVED IN NEXT VERSION OF THE CODE; KEPT FOR CONSISTENCY)
     m_v = randn(N, 100 + T);
     if 0 %cc% 
          m_x = m_v(:, (end - T + 1):end); % TO MAKE THE PREVIOUS RESULTS REPLICABLE
     else
          m_x = invAxs * (sqrt(sigmasq_v) .* m_v(:, (end - T + 1):end)); % N x T
     end

     % distribution of the error
     if gaussian % zeta_{it} ~ IIDN(0,1)
          m_zeta = randn(N, T); %cc%
     else % zeta_{it} ~ [chi^2(2) - 2] / 2
          mat1 = randn(N, T);
          mat2 = randn(N, T);
          m_zeta = ((mat1.^2) + (mat2.^2) - 2) ./ 2;
     end
     m_y = repmat(v_mu, [1 T]) + (m_Phi * m_x) + (m_R * m_zeta); % N x T
     if P == 3 % intercept only
          a_x = ones(N, T, 1);
     elseif P == 4 % intercept plus predeterminated variables
          a_x = ones(N, T, 2);
          a_x(:, :, 2) = m_x;
     else
          error('Something here is not quite right, please check the code before proceeding')
     end

     % store the true theta
     a_theta(:, :, r) = m_theta;
     
     l_out = fn_ml_Npsi_NKbeta_Nsgmsq(m_y, a_x, m_W);
     a_eml(:, :, r) = l_out.m_theta;
     a_vml(:, :, r) = l_out.m_variance;
     a_sml(:, :, r) = l_out.m_sandwich;
end  

%% save results
% load previously stored data
if exist(filesav, 'file')
     load(filesav)
     o_a_theta = l_t.o_a_theta; % old
     o_a_eml   = l_e.o_a_eml; 
     o_a_vml   = l_v.o_a_vml; 
     o_a_sml   = l_s.o_a_sml; 

     disp(['Previous number of iterations: ' int2str(size(o_a_theta, 3))]);
else
     o_a_theta = []; % old
     o_a_eml   = [];
     o_a_vml   = [];
     o_a_sml   = [];
end

% update
n_a_theta = cat(3, o_a_theta , a_theta); % new
n_a_eml   = cat(3, o_a_eml   , a_eml  ); % N x P x R
n_a_vml   = cat(3, o_a_vml   , a_vml  );
n_a_sml   = cat(3, o_a_sml   , a_sml  );

l_t.o_a_theta = n_a_theta;
l_e.o_a_eml   = n_a_eml  ;
l_v.o_a_vml   = n_a_vml  ;
l_s.o_a_sml   = n_a_sml  ;

l_xtra.gaussian = gaussian;
l_xtra.tottime = cputime - t0;

% (over)write the file
save(filesav, ...
'l_t', ...
'l_e', ...
'l_v', ...
'l_s', ...
'l_xtra')
end
