function [m_powe m_null] = fn_power_function(m_parameter_t, m_parameter_e, m_parameter_v, m_delta)
[N R] = size(m_parameter_e);
n_null = size(m_delta, 2);

% check that there are no replications with negative variance
v_ind = find(sum(m_parameter_v < 0, 1) > 0);

% remove replications
if ~isempty(v_ind)
        disp(sprintf('%d replications with negative variance (removed)\n', length(v_ind)))
        m_parameter_t(:, v_ind) = [];
        m_parameter_e(:, v_ind) = [];
        m_parameter_v(:, v_ind) = [];
end

% standard errors
m_parameter_se = realsqrt(m_parameter_v);

% initialise
m_powe = zeros(N, n_null);
m_null = zeros(N, n_null);

cval = abs(norminv(0.025, 0, 1)); % 1.96
for i = 1:N
     for i_null = 1:n_null
          v_parameter_t = m_parameter_t(i, :)'; % (R,1)
          v_parameter_e = m_parameter_e(i, :)'; % (R,1)
          v_parameter_se = m_parameter_se(i, :)'; % (R,1)

          delta = m_delta(i, i_null); % (1,1)

          v_null_hyp = v_parameter_t + delta; % (R,1)
          v_tval = (v_parameter_e - v_null_hyp) ./ v_parameter_se; % (R,1)

          % reject the null (when the null is false, unless delta==0)
          vec = abs(v_tval) > cval; % (R,1)
          m_powe(i, i_null) = mean(vec); % (1,1)
          m_null(i, i_null) = v_null_hyp(1); % (1,1)
     end
end
