clear all
clc
close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%           TWO SIDE CIs  Y          %%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
A=[1;5;10];
AUX=[];
for ii=1:3
alpha=A(ii);
t_up=100-alpha/2;
t_bot=alpha/2;

load('../Section4.1/results_Y_L_RECESSIONS')
BV=[Bootstrapped_Values1 ...
    Bootstrapped_Values1(:,2)-Bootstrapped_Values1(:,1)...
    Bootstrapped_Values1(:,4)-Bootstrapped_Values1(:,3)...
    Bootstrapped_Values1(:,7)-Bootstrapped_Values1(:,6)...
    Bootstrapped_Values1(:,9)-Bootstrapped_Values1(:,8)];
CI_perc = prctile(BV,[t_bot t_up],1)';
Estim_skew=[Estimated_Values_1ststep;...
    Estimated_Values_1ststep(2)-Estimated_Values_1ststep(1);...
    Estimated_Values_1ststep(4)-Estimated_Values_1ststep(3);...
    Estimated_Values_1ststep(7)-Estimated_Values_1ststep(6);...
    Estimated_Values_1ststep(9)-Estimated_Values_1ststep(8)];
CI_perc_L=2*Estim_skew-CI_perc(:,2);
CI_perc_U=2*Estim_skew-CI_perc(:,1);
XX1=[Estim_skew CI_perc_L CI_perc_U];
sig=(100-alpha)*((XX1(:,2)>0 & XX1(:,3)>0)+(XX1(:,2)<0 & XX1(:,3)<0));

AUX=[AUX sig];
end
significance=max(AUX,[],2);
clearvars -except significance Estim_skew

name = {'m2_etaR';'m2_etaE';...
        'm3_etaR';'m3_etaE';...
        'rho';...
        'm2_epsR';'m2_epsE';...
        'm3_epsR';'m3_epsE';...
        'm2_fx';'m3_fx';...
        'b2_fx';'b3_fx';...
        'm2_etaE-m2_etaR';...
        'm3_etaE-m3_etaR';...
        'm2_epsE-m2_epsR';...
        'm3_epsE-m3_epsR'};

two_side_Ci_skew = table(round(Estim_skew,4),significance,'RowNames',name);


A=[1;5;10];
AUX=[];
for ii=1:3
alpha=A(ii);
t_up=100-alpha/2;
t_bot=alpha/2;

load('../Section4.1/results_Y_L_RECESSIONS')
BV=[Bootstrapped_Values2 ...
Bootstrapped_Values2(:,2)-Bootstrapped_Values2(:,1)...
Bootstrapped_Values2(:,2)-3*Estimated_Values_1ststep(2)^2 ...
Bootstrapped_Values2(:,1)-3*Estimated_Values_1ststep(1)^2 ...
Bootstrapped_Values2(:,4)-3*Estimated_Values_1ststep(7)^2 ...
Bootstrapped_Values2(:,3)-3*Estimated_Values_1ststep(6)^2];
CI_perc = prctile(BV,[t_bot t_up],1)';
Estim_kurt=[Estimated_Values_2ndstep;...
Estimated_Values_2ndstep(2)-Estimated_Values_2ndstep(1);...
Estimated_Values_2ndstep(2)-3*Estimated_Values_1ststep(2)^2;...
Estimated_Values_2ndstep(1)-3*Estimated_Values_1ststep(1)^2;...
Estimated_Values_2ndstep(4)-3*Estimated_Values_1ststep(7)^2;...
Estimated_Values_2ndstep(3)-3*Estimated_Values_1ststep(6)^2];
CI_perc_L=2*Estim_kurt-CI_perc(:,2);
CI_perc_U=2*Estim_kurt-CI_perc(:,1);
XX1=[Estim_kurt CI_perc_L CI_perc_U];
sig=(100-alpha)*((XX1(:,2)>0 & XX1(:,3)>0)+(XX1(:,2)<0 & XX1(:,3)<0));

AUX=[AUX sig];
end

significance=max(AUX,[],2);
clearvars -except significance Estim_skew Estim_kurt two_side_Ci_skew

name = {'m4_etaR';'m4_etaE';...
    'm4_epsR';'m4_epsE';...
    'm4_fx';'b4_fx';...
    'm4_etaE-m4_etaR';...
    'm4_etaE>3*m2_etaE';...
    'm4_etaR>3*m2_etaR';...
    'm4_epsE>3*m2_epsE';...
    'm4_epsR>3*m2_epsR'};

two_side_Ci_kurt = table(round(Estim_kurt,4),significance,'RowNames',name);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%           ONE SIDE CIs  Y          %%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
A=[1;5;10];
AUX=[];
for ii=1:3
alpha=A(ii);
t_up=100-alpha/2;
t_bot=alpha/2;

load('../Section4.1/results_Y_L_RECESSIONS')
BV=[Bootstrapped_Values1 ...
    Bootstrapped_Values1(:,2)-Bootstrapped_Values1(:,1)...
    Bootstrapped_Values1(:,4)-Bootstrapped_Values1(:,3)...
    Bootstrapped_Values1(:,7)-Bootstrapped_Values1(:,6)...
    Bootstrapped_Values1(:,9)-Bootstrapped_Values1(:,8)];
CI_perc = prctile(BV,[2*t_bot 100-2*t_bot],1)';
Estim_skew=[Estimated_Values_1ststep;...
    Estimated_Values_1ststep(2)-Estimated_Values_1ststep(1);...
    Estimated_Values_1ststep(4)-Estimated_Values_1ststep(3);...
    Estimated_Values_1ststep(7)-Estimated_Values_1ststep(6);...
    Estimated_Values_1ststep(9)-Estimated_Values_1ststep(8)];
CI_perc_L=2*Estim_skew-CI_perc(:,2);
CI_perc_U=2*Estim_skew-CI_perc(:,1);
XX1=[Estim_skew CI_perc_L CI_perc_U];
sig=(100-alpha)*((XX1(:,2)>0 & XX1(:,3)>0)+(XX1(:,2)<0 & XX1(:,3)<0));

AUX=[AUX sig];
end
significance=max(AUX,[],2);
clearvars -except significance Estim_skew two_side_Ci_skew two_side_Ci_kurt

name = {'m2_etaR';'m2_etaE';...
        'm3_etaR';'m3_etaE';...
        'rho';...
        'm2_epsR';'m2_epsE';...
        'm3_epsR';'m3_epsE';...
        'm2_fx';'m3_fx';...
        'b2_fx';'b3_fx';...
        'm2_etaE-m2_etaR';...
        'm3_etaE-m3_etaR';...
        'm2_epsE-m2_epsR';...
        'm3_epsE-m3_epsR'};

one_side_Ci_skew = table(round(Estim_skew,4),significance,'RowNames',name);


A=[1;5;10];
AUX=[];
for ii=1:3
alpha=A(ii);
t_up=100-alpha/2;
t_bot=alpha/2;

load('../Section4.1/results_Y_L_RECESSIONS')
BV=[Bootstrapped_Values2 ...
Bootstrapped_Values2(:,2)-Bootstrapped_Values2(:,1)...
Bootstrapped_Values2(:,2)-3*Estimated_Values_1ststep(2)^2 ...
Bootstrapped_Values2(:,1)-3*Estimated_Values_1ststep(1)^2 ...
Bootstrapped_Values2(:,4)-3*Estimated_Values_1ststep(7)^2 ...
Bootstrapped_Values2(:,3)-3*Estimated_Values_1ststep(6)^2];
CI_perc = prctile(BV,[2*t_bot 100-2*t_bot],1)';
Estim_kurt=[Estimated_Values_2ndstep;...
Estimated_Values_2ndstep(2)-Estimated_Values_2ndstep(1);...
Estimated_Values_2ndstep(2)-3*Estimated_Values_1ststep(2)^2;...
Estimated_Values_2ndstep(1)-3*Estimated_Values_1ststep(1)^2;...
Estimated_Values_2ndstep(4)-3*Estimated_Values_1ststep(7)^2;...
Estimated_Values_2ndstep(3)-3*Estimated_Values_1ststep(6)^2];
CI_perc_L=2*Estim_kurt-CI_perc(:,2);
CI_perc_U=2*Estim_kurt-CI_perc(:,1);
XX1=[Estim_kurt CI_perc_L CI_perc_U];
sig=(100-alpha)*((XX1(:,2)>0 & XX1(:,3)>0)+(XX1(:,2)<0 & XX1(:,3)<0));

AUX=[AUX sig];
end

significance=max(AUX,[],2);
clearvars -except significance Estim_skew Estim_kurt one_side_Ci_skew two_side_Ci_skew two_side_Ci_kurt

name = {'m4_etaR';'m4_etaE';...
    'm4_epsR';'m4_epsE';...
    'm4_fx';'b4_fx';...
    'm4_etaE-m4_etaR';...
    'm4_etaE>3*m2_etaE';...
    'm4_etaR>3*m2_etaR';...
    'm4_epsE>3*m2_epsE';...
    'm4_epsR>3*m2_epsR'};

one_side_Ci_kurt = table(round(Estim_kurt,4),significance,'RowNames',name);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%           TABLE C1                  %%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

XX1=one_side_Ci_skew.Variables;
XX2=two_side_Ci_skew.Variables;
XX3=one_side_Ci_kurt.Variables;
XX4=two_side_Ci_kurt.Variables;

TABLE_1_x=[XX2(7,:);XX2(6,:);...
           XX2(9,:);XX2(8,:);...
           XX3(4,1) XX3(10,2);...
           XX3(3,1) XX3(11,2)];
     
name = {'m2_epsE';'m2_epsR';...
        'm3_epsE';'m3_epsR';...
        'm4_epsR';'m4_epsE'};
    
Values=TABLE_1_x(:,1);
Significance=round(TABLE_1_x(:,2),0);

TABLE_C1 = table(Values,Significance,'RowNames',name);
    
disp('Table C1:  Transitory income process')
disp(TABLE_C1)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%           TABLE C2                  %%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

XX1=one_side_Ci_skew.Variables;
XX2=two_side_Ci_skew.Variables;
XX3=one_side_Ci_kurt.Variables;
XX4=two_side_Ci_kurt.Variables;

TABLE_2_x=[XX2(10,:);XX2(11,:);XX4(5,:);...
           XX2(12,:);XX2(13,:);XX4(6,:)];
     
name = {'m2_fx';'m3_fx';'m4_fx';...
        'b2_fx';'b3_fx';'b4_fx'};
    
Values=TABLE_2_x(:,1);
Significance=round(TABLE_2_x(:,2),0);

TABLE_C2 = table(Values,Significance,'RowNames',name);
    
disp('Table C2:  Initial conditions')
disp(TABLE_C2)