clear all
clc
close all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%           ONE SIDE CIs  Y          %%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
A=[1;5;10];
AUX=[];
for ii=1:3
alpha=A(ii);
t_up=100-alpha/2;
t_bot=alpha/2;

load('../Section4.2_periods91/results_Y_L_RECESSIONS')
BV=[Bootstrapped_Values1 ...
    Bootstrapped_Values1(:,1)-Bootstrapped_Values1(:,2)...
    Bootstrapped_Values1(:,3)-Bootstrapped_Values1(:,4)];
CI_perc = prctile(BV,[2*t_bot 100-2*t_bot],1)';
Estim_skew=[Estimated_Values_1ststep;...
    Estimated_Values_1ststep(1)-Estimated_Values_1ststep(2);...
    Estimated_Values_1ststep(3)-Estimated_Values_1ststep(4)];
CI_perc_L=2*Estim_skew-CI_perc(:,2);
CI_perc_U=2*Estim_skew-CI_perc(:,1);
XX1=[Estim_skew CI_perc_L CI_perc_U];
sig=(100-alpha)*((XX1(:,2)>0 & XX1(:,3)>0)+(XX1(:,2)<0 & XX1(:,3)<0));

AUX=[AUX sig];
end
significance=max(AUX,[],2);
clearvars -except significance Estim_skew

name = {'m2_etaA';'m2_etaB';...
        'm3_etaA';'m3_etaB';...
        'rho';...
        'm2_epsA';'m3_epsB';...
        'm2_fx';'m3_fx';...
        'b2_fx';'b3_fx';...
        'm2_etaA-m2_etaB';...
        'm3_etaA-m3_etaB'};
    
one_side_Ci_skew91 = table(round(Estim_skew,4),significance,'RowNames',name);    


A=[1;5;10];
AUX=[];
for ii=1:3
alpha=A(ii);
t_up=100-alpha/2;
t_bot=alpha/2;

load('../Section4.2_periods97/results_Y_L_RECESSIONS')
BV=[Bootstrapped_Values1 ...
    Bootstrapped_Values1(:,1)-Bootstrapped_Values1(:,2)...
    Bootstrapped_Values1(:,3)-Bootstrapped_Values1(:,4)];
CI_perc = prctile(BV,[2*t_bot 100-2*t_bot],1)';
Estim_skew=[Estimated_Values_1ststep;...
    Estimated_Values_1ststep(1)-Estimated_Values_1ststep(2);...
    Estimated_Values_1ststep(3)-Estimated_Values_1ststep(4)];
CI_perc_L=2*Estim_skew-CI_perc(:,2);
CI_perc_U=2*Estim_skew-CI_perc(:,1);
XX1=[Estim_skew CI_perc_L CI_perc_U];
sig=(100-alpha)*((XX1(:,2)>0 & XX1(:,3)>0)+(XX1(:,2)<0 & XX1(:,3)<0));

AUX=[AUX sig];
end
significance=max(AUX,[],2);
clearvars -except significance Estim_skew one_side_Ci_skew91

name = {'m2_etaA';'m2_etaB';...
        'm3_etaA';'m3_etaB';...
        'rho';...
        'm2_epsA';'m3_epsB';...
        'm2_fx';'m3_fx';...
        'b2_fx';'b3_fx';...
        'm2_etaA-m2_etaB';...
        'm3_etaA-m3_etaB'};
    
one_side_Ci_skew97 = table(round(Estim_skew,4),significance,'RowNames',name);    


    A=[1;5;10];
AUX=[];
for ii=1:3
alpha=A(ii);
t_up=100-alpha/2;
t_bot=alpha/2;

load('../Section4.2_periods91/results_Y_L_RECESSIONS')
BV=[Bootstrapped_Values2 ...
Bootstrapped_Values2(:,1)-Bootstrapped_Values2(:,2)...
Bootstrapped_Values2(:,2)-3*Estimated_Values_1ststep(2)^2 ...
Bootstrapped_Values2(:,1)-3*Estimated_Values_1ststep(1)^2];
CI_perc = prctile(BV,[2*t_bot 100-2*t_bot],1)';
Estim_kurt=[Estimated_Values_2ndstep;...
Estimated_Values_2ndstep(1)-Estimated_Values_2ndstep(2);...
Estimated_Values_2ndstep(2)-3*Estimated_Values_1ststep(2)^2;...
Estimated_Values_2ndstep(1)-3*Estimated_Values_1ststep(1)^2];
CI_perc_L=2*Estim_kurt-CI_perc(:,2);
CI_perc_U=2*Estim_kurt-CI_perc(:,1);
XX1=[Estim_kurt CI_perc_L CI_perc_U];
sig=(100-alpha)*((XX1(:,2)>0 & XX1(:,3)>0)+(XX1(:,2)<0 & XX1(:,3)<0));

AUX=[AUX sig];
end

significance=max(AUX,[],2);
clearvars -except significance Estim_skew Estim_kurt one_side_Ci_skew91 one_side_Ci_skew97

name = {'m4_etaA';'m4_etaB';...
    'm4_eps';
    'm4_fx';'b4_fx';...
    'm4_etaA-m4_etaB';...
    'm4_etaE>3*m2_etaE';...
    'm4_etaR>3*m2_etaR'};

one_side_Ci_kurt91 = table(round(Estim_kurt,4),significance,'RowNames',name);


    A=[1;5;10];
AUX=[];
for ii=1:3
alpha=A(ii);
t_up=100-alpha/2;
t_bot=alpha/2;

load('../Section4.2_periods97/results_Y_L_RECESSIONS')
BV=[Bootstrapped_Values2 ...
Bootstrapped_Values2(:,1)-Bootstrapped_Values2(:,2)...
Bootstrapped_Values2(:,2)-3*Estimated_Values_1ststep(2)^2 ...
Bootstrapped_Values2(:,1)-3*Estimated_Values_1ststep(1)^2];
CI_perc = prctile(BV,[2*t_bot 100-2*t_bot],1)';
Estim_kurt=[Estimated_Values_2ndstep;...
Estimated_Values_2ndstep(1)-Estimated_Values_2ndstep(2);...
Estimated_Values_2ndstep(2)-3*Estimated_Values_1ststep(2)^2;...
Estimated_Values_2ndstep(1)-3*Estimated_Values_1ststep(1)^2];
CI_perc_L=2*Estim_kurt-CI_perc(:,2);
CI_perc_U=2*Estim_kurt-CI_perc(:,1);
XX1=[Estim_kurt CI_perc_L CI_perc_U];
sig=(100-alpha)*((XX1(:,2)>0 & XX1(:,3)>0)+(XX1(:,2)<0 & XX1(:,3)<0));

AUX=[AUX sig];
end

significance=max(AUX,[],2);
clearvars -except significance Estim_skew Estim_kurt one_side_Ci_skew91 one_side_Ci_skew97 one_side_Ci_kurt91 one_side_Ci_kurt97

name = {'m4_etaA';'m4_etaB';...
    'm4_eps';
    'm4_fx';'b4_fx';...
    'm4_etaA-m4_etaB';...
    'm4_etaE>3*m2_etaE';...
    'm4_etaR>3*m2_etaR'};

one_side_Ci_kurt97 = table(round(Estim_kurt,4),significance,'RowNames',name);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%           TABLE 4                  %%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

XX1=one_side_Ci_skew91.Variables;
XX2=one_side_Ci_skew97.Variables;
XX3=one_side_Ci_kurt91.Variables;
XX4=one_side_Ci_kurt97.Variables;

TABLE_4_x=[XX1(12,:);XX1(13,:);XX3(6,:);XX2(12,:);XX2(13,:);XX4(6,:)];
     
name = {'m2_etaA91-m2_etaB91';...
        'm3_etaA91-m3_etaB91';...
        'm4_etaA91-m4_etaB91';...
        'm2_etaA97-m2_etaB97';...
        'm3_etaA97-m3_etaB97';...
        'm4_etaA97-m4_etaB97'};
    
Values=TABLE_4_x(:,1);
Significance=round(TABLE_4_x(:,2),0);

TABLE_4 = table(Values,Significance,'RowNames',name);
    
disp('Table 4:  Di§erences between periods with different frequency of recessions')
disp(TABLE_4)





